package com.namasoft.common.layout.metadata;

import com.namasoft.common.NaMaDTO;
import com.namasoft.common.utilities.NamaObject;
import com.namasoft.common.utilities.ObjectChecker;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import java.util.ArrayList;
import java.util.List;

@SuppressWarnings("serial")
@XmlAccessorType(XmlAccessType.PROPERTY)
public class FieldTooltipInfoRefList extends NaMaDTO implements NamaObject
{
	private List<FieldTooltipInfoRef> list;

	public List<FieldTooltipInfoRef> getList()
	{
		if (list == null)
			list = new ArrayList<>();
		return list;
	}

	public void setList(List<FieldTooltipInfoRef> list)
	{
		this.list = list;
	}

	@Override
	public boolean isEmpty()
	{
		return ObjectChecker.isEmptyOrNull(list);
	}

	public FieldTooltipInfoRef get(int i)
	{
		return getList().get(i);
	}

	public void add(FieldTooltipInfoRef ref)
	{
		getList().add(ref);
	}
}
