package com.namasoft.common.layout.metadata;

import java.util.ArrayList;
import java.util.List;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;

import com.namasoft.common.NaMaDTO;
import com.namasoft.common.utilities.NamaObject;
import com.namasoft.common.utilities.ObjectChecker;

@SuppressWarnings("serial")
@XmlAccessorType(XmlAccessType.PROPERTY)
public class IndexList extends NaMaDTO implements NamaObject
{
	private List<Integer> indices = new ArrayList<Integer>();

	public List<Integer> getIndices()
	{
		return indices;
	}

	public void setIndices(List<Integer> indices)
	{
		this.indices = indices;
	}

	@Override
	public boolean isEmpty()
	{
		return ObjectChecker.isEmptyOrNull(indices);
	}

}
