package com.namasoft.common.urlutils;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map.Entry;

import com.namasoft.common.constants.BarCodeConstants;
import com.namasoft.common.utilities.Base64;
import com.namasoft.common.utilities.ObjectChecker;

@SuppressWarnings("rawtypes")
public class ObjectToURLUtil
{
	public static <T> List<T> fromURL(String url, PropertySerializer<T> serializer)
	{
		if (ObjectChecker.isEmptyOrNull(url))
			return null;
		url = decode(url);
		String[] objects = url.split(BarCodeConstants.contextsSeparator);
		List<T> objectList = new ArrayList<T>();
		for (int i = 0; i < objects.length; i++)
		{
			String[] properties = objects[i].split(BarCodeConstants.entriesSepaarator);
			HashMap<String, String> propertiesMap = new HashMap<String, String>();
			for (int j = 0; j < properties.length; j++)
			{
				String[] keyValue = properties[j].split(BarCodeConstants.keyValueSepaarator);
				if (keyValue.length != 2)
					continue;
				propertiesMap.put(keyValue[0], keyValue[1]);
			}
			if (ObjectChecker.isNotEmptyOrNull(propertiesMap))
			{
				T object = serializer.fromProperties(propertiesMap);
				if (object != null)
				{
					objectList.add(object);
				}
			}
		}
		return objectList;
	}

	public static <T> String toUrl(List<T> objects, PropertySerializer<T> serializer)
	{
		StringBuilder builder = new StringBuilder();
		if (ObjectChecker.isNotEmptyOrNull(objects))
		{
			for (int i = 0; i < objects.size(); i++)
			{
				addProperties(builder, serializer.toProperties(objects.get(i)));
				if (i < objects.size() - 1)
				{
					builder.append(BarCodeConstants.contextsSeparator);
				}
			}
		}
		return encode(builder);
	}

	public static String encode(StringBuilder builder)
	{
		String string = builder.toString();
		return encode(string);
	}

	public static String encode(String string)
	{
		try
		{
			return Base64.toBase64(string.getBytes("UTF-8"));
		}
		catch (UnsupportedEncodingException e)
		{
			throw new RuntimeException(e);
		}
	}

	public static String decode(String url)
	{
		if (ObjectChecker.isEmptyOrNull(url))
			return "";
		try
		{
			return new String(Base64.fromBase64(url), "UTF-8");
		}
		catch (UnsupportedEncodingException e)
		{
			throw new RuntimeException(e);
		}
	}

	private static void addProperties(StringBuilder builder, HashMap<String, String> properties)
	{
		Entry[] entries = properties.entrySet().toArray(new Entry[] {});
		for (int j = 0; j < entries.length; j++)
		{
			builder.append(entries[j].getKey()).append(BarCodeConstants.keyValueSepaarator)
					.append(ObjectChecker.toStringOrEmpty(entries[j].getValue()));
			if (j < entries.length - 1)
			{
				builder.append(BarCodeConstants.entriesSepaarator);
			}
		}
	}

	public static String listToString(List<String> list)
	{
		StringBuilder value = new StringBuilder();
		if (ObjectChecker.isNotEmptyOrNull(list))
		{
			for (int i = 0; i < list.size(); i++)
			{
				value.append(list.get(i));
				if (i < list.size())
				{
					value.append(BarCodeConstants.listSeperator);
				}
			}
		}
		return value.toString();
	}

	public static List<String> stringToList(String str)
	{
		List<String> list = new ArrayList<String>();
		if (ObjectChecker.isNotEmptyOrNull(str))
		{
			String[] parts = str.split(BarCodeConstants.listSeperator);
			for (int i = 0; i < parts.length; i++)
			{
				list.add(parts[i]);
			}
		}
		return list;
	}

}
