package com.namasoft.common.utilities;

import java.util.ArrayList;
import java.util.List;

import com.namasoft.common.constants.CommonConstants;

public class ApprovalUtils
{
	public static boolean headerApproval(String text)
	{
		return text.equals("-1");
	}

	public static String headerApprovalText()
	{
		return "-1";
	}

	public static List<Integer> calcIndices(String text)
	{
		List<Integer> integers = new ArrayList<Integer>();
		if (ObjectChecker.isEmptyOrNull(text) || headerApproval(text))
			return integers;
		StringBuilder newText = new StringBuilder();
		for (int i = 0; i < text.length(); i++)
		{
			if (!Character.isDigit(text.charAt(i)))
				newText.append(',');
			else
				newText.append(text.charAt(i));
		}
		text = newText.toString();
		String[] split = text.split(",");
		if (split == null)
			return integers;
		for (String num : split)
		{
			if (ObjectChecker.isEmptyOrNull(num))
				continue;
			integers.add(Integer.parseInt(num));
		}
		return integers;
	}

	public static String indicesToText(List<Integer> lineIndices)
	{
		String ret = "";
		if (ObjectChecker.isEmptyOrNull(lineIndices))
			return ret;
		for (int i = 0; i < lineIndices.size(); i++)
			ret += lineIndices.get(i) + ",";
		return ret;
	}

	public static String calcDisplayString(String text)
	{
		if (ObjectChecker.isEmptyOrNull(text) || headerApproval(text))
			return "";
		List<Integer> list = calcIndices(text);
		if (ObjectChecker.isEmptyOrNull(list))
			return "";
		String ret = "" + list.get(0);
		for (int i = 1; i < list.size(); i++)
		{
			ret += "," + list.get(i);
		}
		return ret;
	}

	public static String calcConcernedLines(String values, String employeeId)
	{
		if (values == null)
			values = "";
		String[] parts = values.split(CommonConstants.SEPARATOR);
		for (int i = 0; i < parts.length; i++)
		{
			if (parts[i].startsWith(employeeId))
				return parts[i].substring(employeeId.length() + 1);
		}
		return null;
	}

}
