package com.namasoft.common.utilities;

import com.namasoft.common.exceptions.NaMaServiceExcepption;
import com.namasoft.specialserialization.*;

import java.util.*;

public abstract class CommonDTOClassCalculator implements ReflectionScanningUtil
{
	public static HashMap<String, Class<?>> dtoClasses;
	public static List<String> allEntities;
	public static HashMap<String, Class> dtoTermClasses;
	private static CommonDTOClassCalculator dtoClassCalculatorInstance;

	private static CommonDTOClassCalculator dtoClassCalculatorInstance()
	{
		try
		{
			if (dtoClassCalculatorInstance == null)
				dtoClassCalculatorInstance = (CommonDTOClassCalculator) ObjectCreatorUtil.creator("com.namasoft.erp.gui.server.DTOClassCalculator")
						.create();
			return dtoClassCalculatorInstance;
		}
		catch (Exception e)
		{
			throw new NaMaServiceExcepption("Could not find DTOClassCalculator", e);
		}
	}

	public static Class getDTOClassFor(String entityType)
	{
		if (dtoClasses == null)
			dtoClassCalculatorInstance().doSetup();
		return dtoClasses.get(entityType);
	}

	public static boolean isEntitySubclassOf(String entityType, Class<?> klass)
	{
		Class<?> dtoClass = getDTOClassFor(entityType);
		if (dtoClass == null)
			return false;
		return klass.isAssignableFrom(dtoClass);
	}

	@Override
	public int order()
	{
		return 0;
	}

	public static boolean isDocument(String entityType)
	{
		Class klass = getDTOClassFor(entityType);
		if (klass == null)
			return false;
		return dtoClassCalculatorInstance().isDocumentFile(klass);
	}

	public static boolean isMaster(String entityType)
	{
		return !isDocument(entityType);
	}

	public abstract boolean isDocumentFile(Class<?> klass);

	public static Class getTermDTOClassFor(String documentType)
	{
		return dtoClassCalculatorInstance().termDTOClassFor(documentType);
	}

	public abstract Class termDTOClassFor(String documentType);

	public static <T> ObjectCreator<T> creatorForDetailsClass(String entityType, String detailsName)
	{
		return ObjectCreatorUtil.creator(calcDetailsClass(entityType, detailsName));
	}
	public static Class calcDetailsClass(String entityType, String detailsName)
	{
		try
		{
			return ReflectionUtils.getMethodActualReturnType(getDTOClassFor(entityType).getMethod("get" + StringUtils.firstLetterUpper(detailsName)));
		}
		catch (NoSuchMethodException e)
		{
			throw new RuntimeException(e);
		}
	}
}
