package com.namasoft.common.utilities;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;

import com.namasoft.common.HasId;
import com.namasoft.common.NaMaDTO;
import com.namasoft.common.layout.edit.NaMaText;

@SuppressWarnings("serial")
@XmlAccessorType(XmlAccessType.PROPERTY)
public class DTOConfirmation extends NaMaDTO implements HasId
{
	private String id;
	private Boolean confirmed;
	private NaMaText message;

	@Override
	public String getId()
	{
		return id;
	}

	public void setId(String id)
	{
		this.id = id;
	}

	public Boolean getConfirmed()
	{
		return confirmed;
	}

	public void setConfirmed(Boolean confirmed)
	{
		this.confirmed = confirmed;
	}

	public NaMaText getMessage()
	{
		return message;
	}

	public void setMessage(NaMaText message)
	{
		this.message = message;
	}

	public DTOConfirmation id(String id)
	{
		setId(id);
		return this;
	}

	public DTOConfirmation message(NaMaText message)
	{
		setMessage(message);
		return this;
	}

	public DTOConfirmation confirmed()
	{
		setConfirmed(true);
		return this;
	}

	public DTOConfirmation notConfirmed()
	{
		setConfirmed(false);
		return this;
	}

	public static DTOConfirmation create()
	{
		return new DTOConfirmation();
	}
}
