package com.namasoft.common.utilities;

import com.namasoft.common.utils.GeneralSettings;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.builder.api.*;
import org.apache.logging.log4j.core.config.builder.impl.BuiltConfiguration;
import org.apache.logging.log4j.core.layout.PatternLayout;

import java.lang.reflect.Field;

public class LoggingConfigurator implements NamaUtil
{
	private static String NAMASOFT_LOG = "namasoft.log";
	private static final String PATTERN = "%d %-5p [%c{1}] %m%n";
	private static boolean isInDebugMode = false;
	private static boolean logToConsoleOnly = false;
	private static Boolean isInPOS;

	public static void setNAMASOFT_LOGFileName(String nAMASOFT_LOG)
	{
		NAMASOFT_LOG = nAMASOFT_LOG;
	}

	static
	{
		readIsInDebugMode();
	}

	private static void readIsInDebugMode()
	{
		try
		{
			isInDebugMode = java.lang.management.ManagementFactory.getRuntimeMXBean().getInputArguments().toString().indexOf("-agentlib:jdwp") > 0;
			isInDebugMode = isInDebugMode && Boolean.valueOf(GeneralSettings.getProperty("loginsideeclipse", "true"));
		}
		catch (Exception e)
		{
			isInDebugMode = false;
		}
	}

	private static final Object lock = new Object();
	private static boolean isConfigured = false;

	public static void configureUsingCode(boolean enableSQL)
	{
		synchronized (lock)
		{
			readIsInDebugMode();
			configureLog4J(enableSQL);
		}
	}

	private static void configureLog4J(boolean enableSQL)
	{
		ConfigurationBuilder<BuiltConfiguration> builder = ConfigurationBuilderFactory.newConfigurationBuilder();
		builder.setPackages("com.namasoft.common.utilities");
		if (enableSQL)
			System.setProperty("oracle.jdbc.Trace", "true");
		else
			System.setProperty("oracle.jdbc.Trace", "false");
		createNewRollingFileAppender(builder, "namasoft", NAMASOFT_LOG);
		createNewRollingFileAppender(builder, "sql");
		createNewRollingFileAppender(builder, "other");
		createNewRollingFileAppender(builder, "cost");
		createNewRollingFileAppender(builder, "mail");
		createNewRollingFileAppender(builder, "security");
		createNewRollingFileAppender(builder, "needsfix");
		createNewRollingFileAppender(builder, "replication");
		createNewRollingFileAppender(builder, "performance");
		createNewRollingFileAppender(builder, "reportPerformance");
		createNewRollingFileAppender(builder, "service");
		createNewRollingFileAppender(builder, "gui");
		builder.add(builder.newAppender("namaThreadAppender", "NaMaPerSessionLogAppender").add(createPattern(builder)));

		// configure the root logger
		builder.add(builder.newRootLogger(Level.ERROR).add(builder.newAppenderRef("other")));
		configLogger(builder, "namasoft.normal", "namasoft");
		configLogger(builder, "namasoft.cost", "cost");
		configLogger(builder, "namasoft.mail", "mail");
		configLogger(builder, "namasoft.security", "security");
		configLogger(builder, "namasoft.needsfix", "needsfix");
		configLogger(builder, "namasoft.replication", "replication");
		configLogger(builder, "namasoft.level2.service", "service");
		configLogger(builder, "namasoft.level2.performance", "performance");
		configLogger(builder, "namasoft.level2.reportPerformance", "reportPerformance");
		configLogger(builder, "namasoft.level2.gui", "gui");

		configLogger(builder, "org.hibernate.orm.incubating", Level.ERROR, "other");
		configLogger(builder, "org.hibernate", Level.WARN, "other");
		configLogger(builder, "jdbc.resultset", Level.WARN, "other");
		configLogger(builder, "jdbc.audit", Level.WARN, "other");
		configLogger(builder, "org.apache.cxf", Level.WARN, "other");

		configLogger(builder, "jdbc.connection", Level.WARN, "other");
		configLogger(builder, "jdbc.audit", Level.WARN, "other");
		configLogger(builder, "org.apache.cxf", Level.WARN, "other");
		configLogger(builder, "jdbc.sqlonly", enableSQL ? Level.INFO : Level.WARN, "sql");
		if (isConfigured)
			Configurator.reconfigure(builder.build());
		else
			Configurator.initialize(builder.build());
		isConfigured = true;
	}

	private static void configLogger(ConfigurationBuilder<BuiltConfiguration> builder, String name, String appenderName)
	{
		configLogger(builder, name, Level.ALL, appenderName);
	}

	private static void configLogger(ConfigurationBuilder<BuiltConfiguration> builder, String name, Level level, String appenderName)
	{
		builder.add(builder.newLogger(name, level).addAttribute("additivity", false).add(builder.newAppenderRef(appenderName))
				.add(builder.newAppenderRef("namaThreadAppender")));
	}

	private static void createNewRollingFileAppender(ConfigurationBuilder<BuiltConfiguration> builder, String name)
	{
		createNewRollingFileAppender(builder, name, name + ".log");
	}

	private static void createNewRollingFileAppender(ConfigurationBuilder<BuiltConfiguration> builder, String name, String fileName)
	{
		if (isInDebugMode() || logToConsoleOnly)
		{
			builder.add(builder.newAppender(name, "Console").add(createPattern(builder)));
			return;
		}
		if (!fileName.endsWith(".log"))
			throw new RuntimeException("Invalid log file name " + fileName);
		fileName = fileName.substring(0, fileName.length() - 4);
		ComponentBuilder<?> triggeringPolicy = builder.newComponent("Policies")
				.addComponent(builder.newComponent("SizeBasedTriggeringPolicy").addAttribute("size", "100MB"));
		ComponentBuilder<?> strategy = builder.newComponent("DefaultRolloverStrategy").addAttribute("max", "5");

		builder.add(builder.newAppender(name, "RollingFile").addAttribute("fileName", fileName + ".log")
				.addAttribute("filePattern", fileName + ".%i.log.gz").add(createPattern(builder)).addComponent(triggeringPolicy)
				.addComponent(strategy));
	}

	private static LayoutComponentBuilder createPattern(ConfigurationBuilder<BuiltConfiguration> builder)
	{
		return builder.newLayout(PatternLayout.class.getSimpleName()).addAttribute("pattern", "%d %-5p [%c{1}] %m%n");
	}

	private static void setThreshold(Integer thresholdValue, String thresholdFieldName, String enabledFieldName, Class<?> driverSpy)
			throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException
	{
		Field thresholdField = driverSpy.getDeclaredField(thresholdFieldName);
		thresholdField.setAccessible(true);
		Field enabledField = driverSpy.getDeclaredField(enabledFieldName);
		enabledField.setAccessible(true);

		boolean enable = true;
		if (thresholdValue == null)
		{
			enable = false;
			thresholdValue = 999999999;
		}
		enabledField.set(null, enable);
		thresholdField.set(null, thresholdValue.longValue());
	}

	public static void logToConsoleOnly(boolean logToConsoleOnly)
	{
		LoggingConfigurator.logToConsoleOnly = logToConsoleOnly;
	}

	@Override
	public Object apply(Object... params)
	{
		configureUsingCode(false);
		return "";
	}

	public static boolean isInDebugMode()
	{
		return isInDebugMode;
	}

	public static boolean isInPOS()
	{
		if (isInPOS != null)
			return isInPOS;
		try
		{
			Class.forName("com.namasoft.pos.application.PosEntryPoint");
			isInPOS = true;
		}
		catch (Exception e)
		{
			isInPOS = false;
		}
		return isInPOS;
	}

	public static void enableSqlLogging()
	{
		configureUsingCode(true);
	}
}
