package com.namasoft.common.utilities;

import com.namasoft.common.constants.PlaceTokens;

import java.util.HashMap;

public class NaMaKeyValuePairsTokenizer
{

	public static class KeyValuePair
	{
		private String key;
		private Object value;

		public String getKey()
		{
			return key;
		}

		public void setKey(String key)
		{
			this.key = key;
		}

		public Object getValue()
		{
			return value;
		}

		public void setValue(Object value)
		{
			this.value = value;
		}

		public KeyValuePair(String key, Object value)
		{
			setKey(key);
			setValue(value);
		}
	}

	public static KeyValuePair pair(String key, Object value)
	{
		return new KeyValuePair(key, value);
	}

	public static HashMap<String, String> detokenize(String token)
	{
		HashMap<String, String> values = new HashMap<String, String>();
		token += PlaceTokens.PARAMETERS_SEPERATOR;
		String[] keyValuePairs = token.split(PlaceTokens.PARAMETERS_SEPERATOR);
		for (String keyValuePair : keyValuePairs)
		{
			String[] parts = keyValuePair.split(PlaceTokens.PAIR_SEPERATOR);
			if (parts.length != 2) // ignore any malformed parameters
				continue;

			String key = parts[0];
			String value = "";
			if (parts.length > 1)
				value = parts[1];
			values.put(key, value);
		}
		return values;
	}

	public static String tokenize(KeyValuePair... keyValuePairs)
	{
		String token = "";
		if (keyValuePairs == null)
			return token;
		for (int i = 0; i < keyValuePairs.length; i++)
		{
			if (ObjectChecker.isNotEmptyOrNull(keyValuePairs[i].getValue()))
			{
				token += keyValuePairs[i].getKey() + PlaceTokens.PAIR_SEPERATOR + keyValuePairs[i].getValue();
				if (i < keyValuePairs.length - 1)
					token += PlaceTokens.PARAMETERS_SEPERATOR;
			}
		}
		return token;
	}
}
