package com.namasoft.common.utilities;

import java.text.DecimalFormat;
import java.util.*;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class NaMaProfiler
{
	private static final NaMaProfiler instance = new NaMaProfiler();
	private final Map<String, Long> startTimes = new ConcurrentHashMap<>();

	public static NaMaProfiler get()
	{
		return instance;
	}

	public void start(String id)
	{
		startTimes.put(id, System.nanoTime());
	}

	public void lapse(String id, Object... extraMessages)
	{
		lapse(id, startTimes.get(id), extraMessages);
	}

	public void end(String id, Object... extraMessages)
	{
		Long start = startTimes.remove(id);
		lapse(id, start, extraMessages);
	}

	private void lapse(String id, Long start, Object... extraMessages)
	{
		if (start != null)
		{
			long end = System.nanoTime();
			long time = end - start;
			printLapse(id, time, extraMessages);
		}
	}

	public static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("###,###");

	private void printLapse(String id, long time, Object... extraMessages)
	{
		long micros = time / 1000;
		String msgs =
				extraMessages.length > 0 ? Arrays.stream(extraMessages).map(ObjectChecker::toStringOrEmpty).collect(Collectors.joining(" ")) : "";
		print("Profiler: " + id + " - time: " + (micros >= 1000 ? DECIMAL_FORMAT.format(micros) : micros) + " microS " + msgs);
	}

	private void print(String msg)
	{
		NaMaLogger.performance(msg);
	}

}
