package com.namasoft.common.utilities;

public enum TrueFalseNotSpecified
{
	True, False, NotSpecified;

	public static TrueFalseNotSpecified fromBoolean(Boolean b)
	{
		if (ObjectChecker.isTrue(b))
			return True;
		return False;
	}

	public boolean isTrue()
	{
		return this == True;
	}

	public boolean isTrueOrNotSpecified()
	{
		return isTrue() || isNotSpecified();
	}

	public boolean isFalse()
	{
		return this == False;
	}

	public boolean isNotSpecified()
	{
		return this == NotSpecified;
	}

	public boolean isSpecified()
	{
		return !isNotSpecified();
	}

	public Boolean toBoolean()
	{
		if (isTrue())
			return true;
		if (isFalse())
			return false;
		return null;
	}
}
