package com.namasoft.common.utils;

import com.namasoft.common.NaMaDTO;
import com.namasoft.common.utilities.ObjectChecker;
import org.apache.commons.io.FileUtils;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.File;
import java.io.IOException;

@SuppressWarnings("serial")
@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class HTMLReportResult extends NaMaDTO
{
	private String mainFile;
	private Boolean empty;
	private String text;
	private String tempPrintId;
	private String repFormat;

	public static HTMLReportResult createFromFile(String fileName)
	{
		HTMLReportResult htmlReportResult = new HTMLReportResult();
		htmlReportResult.setMainFile(fileName);
		htmlReportResult.setEmpty(false);
		return htmlReportResult;
	}

	public static HTMLReportResult createFromStr(String str)
	{
		HTMLReportResult htmlReportResult = new HTMLReportResult();
		htmlReportResult.setEmpty(false);
		htmlReportResult.setText(str);
		return htmlReportResult;
	}

	private HTMLReportResult()
	{
	}

	public String getMainFile()
	{
		return mainFile;
	}

	public void setMainFile(String mainFile)
	{
		this.mainFile = mainFile;
	}

	public Boolean getEmpty()
	{
		return empty;
	}

	public void setEmpty(Boolean empty)
	{
		this.empty = empty;
	}

	public String getText()
	{
		return text;
	}

	public void setText(String contentAsStr)
	{
		this.text = contentAsStr;
	}

	public String readFile()
	{
		if (ObjectChecker.isEmptyOrNull(getMainFile()))
			return "";
		try
		{
			return FileUtils.readFileToString(new File(getMainFile()), "utf-8");
		}
		catch (IOException e)
		{
			throw new RuntimeException(e);
		}
	}

	public String getRepFormat()
	{
		return repFormat;
	}

	public void setRepFormat(String repFormat)
	{
		this.repFormat = repFormat;
	}

	public String getTempPrintId()
	{
		return tempPrintId;
	}

	public void setTempPrintId(String tempPrintId)
	{
		this.tempPrintId = tempPrintId;
	}
}
