package com.namasoft.common.utils.importer.data;

import com.namasoft.common.*;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utils.importer.parser.RecordImportHelper;

import jakarta.xml.bind.annotation.*;

@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class FieldValue extends NaMaDTO implements HasId
{
	private String id;
	private String value;

	private FieldValue()
	{
	}

	public FieldValue(String id, String value)
	{
		this();
		this.id = id;
		this.value = value;
	}

	public String getId()
	{
		return id;
	}

	public void setId(String id)
	{
		this.id = id;
	}

	public String getValue()
	{
		return value;
	}

	public String calcValue(RecordImportHelper<?> helper)
	{
		if (ObjectChecker.isNotEmptyOrNull(getValue()) && getValue().startsWith("evalsql("))
			return helper.evaluateValue(getValue());
		return getValue();
	}
	public void setValue(String value)
	{
		this.value = value;
	}

	@Override
	public String toString()
	{
		return getId() + ": " + getValue();
	}

	public void mergeWith(FieldValue source)
	{
		if (source == null)
			return;
		if (ObjectChecker.isNotEmptyOrNull(source.getValue()))
			setValue(source.getValue());
	}
}
