package com.namasoft.common.utils.translation;

import java.util.List;

import com.namasoft.common.constants.Language;

public interface MessageTranslator
{
	String translate(Language lang, String message, Object... arguments);

	List<String> getKeys();

	long getOrder();

	void processRecursions(AggregatedMessageTranslator aggregatedTranslator);

	void replace(String key, String value);

	void processReplacements(List<MessageTranslator> translators);

}
