package com.namasoft.taxauthority;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;

import java.util.List;

@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class TaxAuthorityExportDebitNote extends TaxAuthorityAbsExportDocument
{
	private List<String> references;

	public TaxAuthorityExportDebitNote()
	{
		setDocumentType("ED");
	}

	public List<String> getReferences()
	{
		return references;
	}

	public void setReferences(List<String> references)
	{
		this.references = references;
	}

	@Override
	public void updateReferences(List<String> references)
	{
		setReferences(references);
	}

	@Override
	public String edocumentType()
	{
		return "ExportDebitNote";
	}
}