/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail.resolver;

import jakarta.activation.DataSource;
import jakarta.activation.URLDataSource;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.mail.resolver.DataSourceBaseResolver;

public class DataSourceUrlResolver
extends DataSourceBaseResolver {
    private final URL baseUrl;

    public DataSourceUrlResolver(URL baseUrl) {
        this.baseUrl = baseUrl;
    }

    public DataSourceUrlResolver(URL baseUrl, boolean lenient) {
        super(lenient);
        this.baseUrl = baseUrl;
    }

    public URL getBaseUrl() {
        return this.baseUrl;
    }

    @Override
    public DataSource resolve(String resourceLocation) throws IOException {
        return this.resolve(resourceLocation, this.isLenient());
    }

    @Override
    public DataSource resolve(String resourceLocation, boolean isLenient) throws IOException {
        URLDataSource result = null;
        try {
            if (!this.isCid(resourceLocation)) {
                URL url = this.createUrl(resourceLocation);
                result = new URLDataSource(url);
                result.getInputStream();
            }
            return result;
        }
        catch (IOException e) {
            if (isLenient) {
                return null;
            }
            throw e;
        }
    }

    protected URL createUrl(String resourceLocation) throws MalformedURLException {
        if (this.baseUrl == null) {
            return new URL(resourceLocation);
        }
        if (resourceLocation == null || resourceLocation.isEmpty()) {
            throw new IllegalArgumentException("No resource defined");
        }
        if (this.isFileUrl(resourceLocation) || this.isHttpUrl(resourceLocation)) {
            return new URL(resourceLocation);
        }
        return new URL(this.getBaseUrl(), resourceLocation.replace("&amp;", "&"));
    }
}

