/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.upgrader.migrator;

import com.namasoft.upgrader.ProcessesUtil;
import com.namasoft.upgrader.Upgrader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class TomcatExeArgsParser {
    private final List<TomcatArg> args = new ArrayList<TomcatArg>();

    public int getMaxMemoryInMB() {
        return this.args.stream().filter(a -> a.name.toLowerCase().contains("jvmmx")).map(a -> Integer.parseInt(a.value)).findFirst().orElse(0);
    }

    public String getJvm() {
        return this.args.stream().filter(a -> a.name.equals("--Jvm")).findFirst().map(TomcatArg::value).orElse("");
    }

    public String getJvmOptions9() {
        return this.args.stream().filter(a -> a.name.equals("--JvmOptions9")).findFirst().map(TomcatArg::value).orElse("");
    }

    public String getJvmOptions() {
        return this.args.stream().filter(a -> a.name.equals("--JvmOptions")).findFirst().map(TomcatArg::value).orElse("");
    }

    public static TomcatExeArgsParser fetchAndParse(String tomcatPath) throws IOException, InterruptedException {
        File tomcatExe = Upgrader.calcTomcatExeFile(tomcatPath);
        String output = ProcessesUtil.runProcessAndGetOutput(tomcatExe.getAbsolutePath(), "print").getFirst();
        int startFrom = 0;
        TomcatExeArgsParser parser = new TomcatExeArgsParser();
        while ((startFrom = output.indexOf("--", startFrom)) >= 0) {
            String argValue;
            int argNameEnd = output.indexOf(32, startFrom);
            if (argNameEnd < 0) {
                return parser;
            }
            String argName = output.substring(startFrom, argNameEnd);
            if (output.charAt(argNameEnd + 1) == '\"') {
                argValueStart = argNameEnd + 2;
                argValueEnd = output.indexOf(34, argValueStart);
                if (argValueEnd < 0) {
                    argValue = output.substring(argValueStart);
                    startFrom = output.length();
                } else {
                    argValue = output.substring(argValueStart, argValueEnd);
                    startFrom = argValueEnd + 1;
                }
            } else {
                argValueStart = argNameEnd + 1;
                argValueEnd = output.indexOf(32, argValueStart);
                if (argValueEnd < 0) {
                    argValue = output.substring(argValueStart);
                    startFrom = output.length();
                } else {
                    argValue = output.substring(argValueStart, argValueEnd);
                    startFrom = argValueEnd + 1;
                }
            }
            parser.args.add(new TomcatArg(argName, argValue));
        }
        return parser;
    }

    public record TomcatArg(String name, String value) {
    }
}

