/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.modules.supplychain.contracts.details;

import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.modules.commonbasic.contracts.invoicing.IDTOPriceListOfferLine;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOGenericDimensions;
import com.namasoft.modules.supplychain.contracts.details.GeneratedDTOItemDiscountLine;
import com.namasoft.modules.supplychain.contracts.details.IDTOHasPrice;
import com.namasoft.modules.supplychain.contracts.details.IPriceUpdateTarget;
import com.namasoft.modules.supplychain.enums.DiscountUpdaterField;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.math.BigDecimal;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class DTOItemDiscountLine
extends GeneratedDTOItemDiscountLine
implements Serializable,
IDTOPriceListOfferLine,
IPriceUpdateTarget,
IDTOHasPrice {
    public void updateAnalysisSet(EntityReferenceData analysisSet) {
        this.initializeDimensions();
        this.getDimensions().setAnalysisSet(analysisSet);
    }

    public void updateLegalEntity(EntityReferenceData legalEntity) {
        this.initializeDimensions();
        this.getDimensions().setLegalEntity(legalEntity);
    }

    public void updateDepartment(EntityReferenceData department) {
        this.initializeDimensions();
        this.getDimensions().setDepartment(department);
    }

    public void updateSector(EntityReferenceData sector) {
        this.initializeDimensions();
        this.getDimensions().setSector(sector);
    }

    public void updateBranch(EntityReferenceData branch) {
        this.initializeDimensions();
        this.getDimensions().setBranch(branch);
    }

    public void initializeDimensions() {
        if (ObjectChecker.isEmptyOrNull((Object)this.getDimensions())) {
            this.setDimensions(new DTOGenericDimensions());
        }
    }

    @Override
    public BigDecimal fetchPriceFromField(String fieldStr) {
        DiscountUpdaterField field = DiscountUpdaterField.valueOf(fieldStr);
        BigDecimal price = BigDecimal.ZERO;
        switch (field) {
            case MinDiscount: {
                price = this.getDiscountMinValue();
                break;
            }
            case MaxDiscount: {
                price = this.getDiscountMaxValue();
                break;
            }
            case DefaultDiscount: {
                price = this.getDiscountDefaultValue();
            }
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)price)) {
            return price;
        }
        return BigDecimal.ZERO;
    }

    @Override
    public void updatePriceForField(String field, BigDecimal price) {
        DiscountUpdaterField fields = DiscountUpdaterField.valueOf(field);
        switch (fields) {
            case MinDiscount: {
                this.setDiscountMinValue(price);
                break;
            }
            case MaxDiscount: {
                this.setDiscountMaxValue(price);
                break;
            }
            case DefaultDiscount: {
                this.setDiscountDefaultValue(price);
            }
        }
    }

    @Override
    public void updatePrice(BigDecimal min, BigDecimal max, BigDecimal defaultPrice, BigDecimal n1, BigDecimal n2, BigDecimal n3, BigDecimal n4, BigDecimal n5) {
    }
}

