/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.modules.supplychain.contracts.details;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.modules.supplychain.contracts.details.GeneratedDTOSalesPriceListLine;
import com.namasoft.modules.supplychain.contracts.details.IDTOHasPrice;
import com.namasoft.modules.supplychain.enums.PriceUpdaterField;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.math.BigDecimal;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class DTOSalesPriceListLine
extends GeneratedDTOSalesPriceListLine
implements Serializable,
IDTOHasPrice {
    @Override
    public BigDecimal fetchPriceFromField(String fieldStr) {
        BigDecimal price = BigDecimal.ZERO;
        PriceUpdaterField field = PriceUpdaterField.valueOf(fieldStr);
        switch (field) {
            case MinPrice: {
                price = this.getMinPrice();
                break;
            }
            case MaxPrice: {
                price = this.getMaxPrice();
                break;
            }
            case DefaultPrice: {
                price = this.getDefaultPrice();
                break;
            }
            case N1: {
                price = this.getN1();
                break;
            }
            case N2: {
                price = this.getN2();
                break;
            }
            case N3: {
                price = this.getN3();
                break;
            }
            case N4: {
                price = this.getN4();
                break;
            }
            case N5: {
                price = this.getN5();
            }
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)price)) {
            return price;
        }
        return BigDecimal.ZERO;
    }

    @Override
    public void updatePriceForField(String fieldStr, BigDecimal price) {
        PriceUpdaterField field = PriceUpdaterField.valueOf(fieldStr);
        switch (field) {
            case MinPrice: {
                this.setMinPrice(price);
                break;
            }
            case MaxPrice: {
                this.setMaxPrice(price);
                break;
            }
            case DefaultPrice: {
                this.setDefaultPrice(price);
                break;
            }
            case N1: {
                this.setN1(price);
                break;
            }
            case N2: {
                this.setN2(price);
                break;
            }
            case N3: {
                this.setN3(price);
                break;
            }
            case N4: {
                this.setN4(price);
                break;
            }
            case N5: {
                this.setN5(price);
            }
        }
    }

    @Override
    public void updatePrice(BigDecimal min, BigDecimal max, BigDecimal defaultPrice, BigDecimal n1, BigDecimal n2, BigDecimal n3, BigDecimal n4, BigDecimal n5) {
        this.setMinPrice(min);
        this.setMaxPrice(max);
        this.setDefaultPrice(defaultPrice);
        this.setN1(n1);
        this.setN2(n2);
        this.setN3(n3);
        this.setN4(n4);
        this.setN5(n5);
    }
}

