/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.modules.supplychain.contracts.dtos;

import com.namasoft.common.NaMaDTO;
import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.common.utilities.ObjectChecker;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.Date;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class FindInvItemByCodeRequest
extends NaMaDTO {
    private static final long serialVersionUID = -2040255463560678400L;
    private String code = "";
    private String requesterType = "";
    private EntityReferenceData supplier;
    private EntityReferenceData customer;
    private EntityReferenceData warehouse;
    private EntityReferenceData legalEntity;
    private Date valueDate;
    private String entityType;

    public static FindInvItemByCodeRequest createRequest(String code, String requesterType, EntityReferenceData customerOrSupplier, EntityReferenceData warehouse, EntityReferenceData legalEntity, Date valueDate, String entityType) {
        EntityReferenceData customer = null;
        EntityReferenceData supplier = null;
        if (ObjectChecker.isNotEmptyOrNull((Object)customerOrSupplier)) {
            if (ObjectChecker.areEqual((Object)"Customer", (Object)customerOrSupplier.getEntityType())) {
                customer = customerOrSupplier;
            } else if (ObjectChecker.areEqual((Object)"Supplier", (Object)customerOrSupplier.getEntityType())) {
                supplier = customerOrSupplier;
            }
        }
        return new FindInvItemByCodeRequest(code, requesterType, customer, supplier, warehouse, legalEntity, valueDate, entityType);
    }

    public EntityReferenceData getWarehouse() {
        return this.warehouse;
    }

    public void setWarehouse(EntityReferenceData warehouse) {
        this.warehouse = warehouse;
    }

    public FindInvItemByCodeRequest() {
    }

    private FindInvItemByCodeRequest(String code, String requesterType, EntityReferenceData customer, EntityReferenceData supplier, EntityReferenceData warehouse, EntityReferenceData legalEntity, Date valueDate, String entityType) {
        this();
        this.code = code;
        this.requesterType = requesterType;
        this.customer = customer;
        this.supplier = supplier;
        this.warehouse = warehouse;
        this.valueDate = valueDate;
        this.legalEntity = legalEntity;
        this.entityType = entityType;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getRequesterType() {
        return this.requesterType;
    }

    public void setRequesterType(String requesterType) {
        this.requesterType = requesterType;
    }

    public EntityReferenceData getSupplier() {
        return this.supplier;
    }

    public void setSupplier(EntityReferenceData supplier) {
        this.supplier = supplier;
    }

    public EntityReferenceData getCustomer() {
        return this.customer;
    }

    public void setCustomer(EntityReferenceData customer) {
        this.customer = customer;
    }

    public EntityReferenceData getLegalEntity() {
        return this.legalEntity;
    }

    public void setLegalEntity(EntityReferenceData legalEntity) {
        this.legalEntity = legalEntity;
    }

    public Date getValueDate() {
        return this.valueDate;
    }

    public void setValueDate(Date valueDate) {
        this.valueDate = valueDate;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public void setEntityType(String entityType) {
        this.entityType = entityType;
    }
}

