/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.httpcommon;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.namasoft.common.exceptions.NaMaServiceExcepption;
import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utils.GeneralSettings;
import com.namasoft.httpcommon.oauth.HttpMethod;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.htmlparser.jericho.Renderer;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.Source;
import org.apache.commons.io.IOUtils;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPatch;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.net.URIBuilder;
import org.apache.hc.core5.util.Timeout;

public interface HttpClient
extends Closeable {
    public static final String CONTENT_TYPE = "Content-Type";
    public static final int CONNECTION_TIMEOUT_MS = 3600000;
    public static final RequestConfig REQUESTS_CONFIG = RequestConfig.custom().setConnectionRequestTimeout(Timeout.of((long)3600000L, (TimeUnit)TimeUnit.MILLISECONDS)).setConnectTimeout(Timeout.of((long)3600000L, (TimeUnit)TimeUnit.MILLISECONDS)).build();

    public ContentType getContentType();

    default public String contentType() {
        if (ObjectChecker.isEmptyOrNull((Object)this.getContentType())) {
            return null;
        }
        return this.getContentType().getMimeType();
    }

    public ObjectMapper mapper();

    public CloseableHttpClient httpClient();

    @Override
    default public void close() throws IOException {
        CloseableHttpClient client = this.httpClient();
        if (client != null) {
            client.close();
        }
    }

    default public Map<String, Object> get(String url) {
        return this.get(url, new HashMap<String, String>());
    }

    default public Map<String, Object> get(String url, Map<String, String> headers) {
        return this.get(url, headers, new HashMap<String, String>(), Map.class);
    }

    default public Map<String, Object> get(String url, Map<String, String> headers, Map<String, String> params) {
        return this.get(url, headers, params, Map.class);
    }

    default public <T> T get(String url, Class<T> klass) {
        return this.get(url, new HashMap<String, String>(), new HashMap<String, String>(), klass);
    }

    default public <T> T get(String url, Map<String, String> headers, Map<String, String> params, Class<T> klass) {
        return this.getEntityAndReleaseConnection((HttpUriRequestBase)this.createGetRequest(url, headers, params), klass);
    }

    default public List<Object> getAll(String url) {
        return this.getEntityAndReleaseConnection((HttpUriRequestBase)this.createGetRequest(url, new HashMap<String, String>(), new HashMap<String, String>()), List.class);
    }

    default public List<Map<String, Object>> getAll(String url, Map<String, String> headers) {
        return CollectionsUtility.castList(this.getAll(url, headers, new HashMap<String, String>(), Map.class));
    }

    default public List<Map<String, Object>> getAll(String url, Map<String, String> headers, Map<String, String> params) {
        return CollectionsUtility.castList(this.getAll(url, headers, params, Map.class));
    }

    default public <T> List<T> getAll(String url, Class<T> klass) {
        return this.getListAndReleaseConnection((HttpUriRequestBase)this.createGetRequest(url, new HashMap<String, String>(), new HashMap<String, String>()), klass);
    }

    default public <T> List<T> getAll(String url, Map<String, String> headers, Map<String, String> params, Class<T> klass) {
        return this.getListAndReleaseConnection((HttpUriRequestBase)this.createGetRequest(url, headers, params), klass);
    }

    default public <T> List<T> getAll(String url, Map<String, String> params, Class<T> klass) {
        return this.getListAndReleaseConnection((HttpUriRequestBase)this.createGetRequest(url, new HashMap<String, String>(), params), klass);
    }

    default public Map<String, Object> send(String url, Map<String, String> headers, Map<String, String> params, Map<String, Object> object, HttpMethod method) {
        try {
            return this.sendEntity(object, this.createMethodRequest(url, headers, params, this.contentType(), method));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    default public Map<String, Object> post(String url, Map<String, String> headers, Map<String, String> params, Map<String, Object> object) {
        try {
            return this.sendEntity(object, (HttpUriRequestBase)this.createPostRequest(url, headers, params));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    default public <T, R> R post(String url, Map<String, String> headers, Map<String, String> params, T object, Class<R> returnClass) {
        try {
            return this.postEntity(object, (HttpUriRequestBase)this.createPostRequest(url, headers, params), returnClass);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    default public <T> Map<String, Object> postObjectAndReturnMapResponse(String url, Map<String, String> headers, Map<String, String> params, T object) {
        try {
            return this.postEntity(object, (HttpUriRequestBase)this.createPostRequest(url, headers, params, this.contentType()), Map.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    default public Map<String, Object> putObjectAndReturnMapIfError(String url, Map<String, String> headers, Map<String, String> params, Map<String, Object> body) {
        try {
            HttpPut request = this.createPutRequest(url, headers, params, this.contentType());
            ByteArrayEntity entity = new ByteArrayEntity(this.mapper().writeValueAsBytes(body), this.getContentType());
            request.setEntity((HttpEntity)entity);
            return this.getEntityAndReleaseConnectionIfError((HttpUriRequestBase)request, Map.class, true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    default public <T> Map<String, Object> putObjectAndReturnMapIfError(String url, Map<String, String> headers, Map<String, String> params, T object) {
        try {
            HttpPut request = this.createPutRequest(url, headers, params, this.contentType());
            ByteArrayEntity entity = new ByteArrayEntity(this.mapper().writeValueAsBytes(object), this.getContentType());
            request.setEntity((HttpEntity)entity);
            return this.getEntityAndReleaseConnectionIfError((HttpUriRequestBase)request, Map.class, true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    default public <T> Map<String, Object> putObjectAndReturnMapResponse(String url, Map<String, String> headers, Map<String, String> params, T object) {
        return this.putObjectAndReturnMapResponse(url, headers, params, object, ContentType.APPLICATION_JSON);
    }

    default public <T> Map<String, Object> putObjectAndReturnMapResponse(String url, Map<String, String> headers, Map<String, String> params, T object, ContentType contentType) {
        try {
            return this.postEntity(object, (HttpUriRequestBase)this.createPutRequest(url, headers, params, contentType.getMimeType()), Map.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    default public <T> Map<String, Object> postURLEncoded(String url, Map<String, String> headers, Map<String, String> params) {
        try {
            return this.getEntityAndReleaseConnection((HttpUriRequestBase)this.createPostRequest(url, headers, params, ContentType.APPLICATION_FORM_URLENCODED.getMimeType()), Map.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    default public <T> T postObjectAndReturnCustomType(String url, Map<String, String> headers, Map<String, String> params, Object object, Class<T> klassToReturn) {
        try {
            return this.postEntity(object, (HttpUriRequestBase)this.createPostRequest(url, headers, params), klassToReturn);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    default public Map<String, Object> put(String url, Map<String, String> params, Map<String, Object> object) {
        try {
            return this.sendEntity(object, (HttpUriRequestBase)this.createPutRequest(url, params));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    default public Map<String, Object> delete(String url, Map<String, String> params) {
        try {
            return this.getEntityAndReleaseConnection((HttpUriRequestBase)this.createDeleteRequest(url, params), Map.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    default public Map<String, Object> sendEntity(Map<String, Object> objectForJson, HttpUriRequestBase httpRequest) {
        try {
            ByteArrayEntity entity = new ByteArrayEntity(this.mapper().writeValueAsBytes(objectForJson), this.getContentType());
            httpRequest.setEntity((HttpEntity)entity);
            return this.getEntityAndReleaseConnection(httpRequest, Map.class);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    default public <T, R> R postEntity(T objectForJson, Class<R> returnClass, HttpUriRequestBase httpPost) {
        try {
            ByteArrayEntity entity = new ByteArrayEntity(this.mapper().writeValueAsBytes(objectForJson), this.getContentType());
            httpPost.setEntity((HttpEntity)entity);
            return this.getEntityAndReleaseConnection(httpPost, returnClass);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    default public <T, E> E postEntity(T objectForJson, HttpUriRequestBase httpPost, Class<E> toReturnClass) {
        try {
            ByteArrayEntity entity = new ByteArrayEntity(this.mapper().writeValueAsBytes(objectForJson), ContentType.APPLICATION_JSON);
            httpPost.setEntity((HttpEntity)entity);
            return this.getEntityAndReleaseConnection(httpPost, toReturnClass);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    default public <T> T getEntityAndReleaseConnection(HttpUriRequestBase httpRequest, Class<T> objectClass) {
        return this.getEntityAndReleaseConnectionIfError(httpRequest, objectClass, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public <T> T getEntityAndReleaseConnectionIfError(HttpUriRequestBase httpRequest, Class<T> objectClass, boolean entityForError) {
        try (CloseableHttpResponse httpResponse = this.httpClient().execute((ClassicHttpRequest)httpRequest);){
            HttpEntity httpEntity = httpResponse.getEntity();
            if (httpEntity == null) {
                throw new RuntimeException("Error retrieving results from http request");
            }
            this.checkValidResponse(httpResponse);
            if (entityForError && !this.ifAPIError(httpResponse)) {
                T t = null;
                return t;
            }
            T result = this.parseResponseContent(httpEntity.getContent(), objectClass);
            if (!objectClass.isInstance(result)) throw new RuntimeException("Can not parse retrieved object: " + result.toString());
            T cast = objectClass.cast(result);
            this.addStatusToCastedObject(httpResponse, cast);
            T t = cast;
            return t;
        }
        catch (Exception e) {
            if (!(e instanceof RuntimeException)) throw new RuntimeException(e);
            throw (RuntimeException)e;
        }
    }

    default public <T> T parseResponseContent(InputStream content, Class<T> returnClass) throws IOException {
        String contentStr = null;
        if (ObjectChecker.isTrue((Boolean)GeneralSettings.getPropertyBoolean((String)"debug-http-json-response"))) {
            contentStr = IOUtils.toString((InputStream)content, (String)"utf-8");
            NaMaLogger.info((Object)contentStr);
            if (ObjectChecker.isEmptyOrNull((Object)contentStr)) {
                contentStr = "{}";
            }
        }
        if (returnClass == ResultAsSTR.class) {
            return (T)new ResultAsSTR(contentStr == null ? IOUtils.toString((InputStream)content, (String)"utf-8") : contentStr);
        }
        if (contentStr != null) {
            return (T)this.mapper().readValue(contentStr, returnClass);
        }
        return (T)this.mapper().readValue(content, returnClass);
    }

    default public void addStatusToCastedObject(CloseableHttpResponse response, Object castedObject) {
    }

    default public HttpPost createPostRequest(String url, Map<String, String> headers, Map<String, String> params) throws Exception {
        return this.createPostRequest(url, headers, params, this.contentType());
    }

    default public HttpPost createPostRequest(String url, Map<String, String> headers, Map<String, String> params, String contentType) throws Exception {
        return (HttpPost)this.createMethodRequest(url, headers, params, contentType, HttpMethod.POST);
    }

    default public HttpUriRequestBase createMethodRequest(String url, Map<String, String> headers, Map<String, String> params, String contentType, HttpMethod method) throws Exception {
        URIBuilder uriBuilder = new URIBuilder(url);
        List<Object> parametersAsList = new ArrayList();
        if (ObjectChecker.isNotEmptyOrNull(params)) {
            parametersAsList = this.getParametersAsList(params);
        }
        UrlEncodedFormEntity entity = null;
        if (ObjectChecker.areEqual((Object)contentType, (Object)ContentType.APPLICATION_FORM_URLENCODED.getMimeType())) {
            entity = new UrlEncodedFormEntity(parametersAsList, StandardCharsets.UTF_8);
        } else {
            uriBuilder.addParameters(parametersAsList);
        }
        HttpUriRequestBase httpReq = this.createMethodRequest(method, uriBuilder);
        httpReq.setEntity((HttpEntity)entity);
        httpReq.setHeader(CONTENT_TYPE, (Object)contentType);
        httpReq.setConfig(REQUESTS_CONFIG);
        for (Map.Entry<String, String> header : headers.entrySet()) {
            httpReq.addHeader(header.getKey(), (Object)header.getValue());
        }
        return httpReq;
    }

    default public HttpUriRequestBase createMethodRequest(HttpMethod method, URIBuilder uriBuilder) throws URISyntaxException {
        return switch (method) {
            default -> throw new MatchException(null, null);
            case HttpMethod.POST -> new HttpPost(uriBuilder.build());
            case HttpMethod.PUT -> new HttpPut(uriBuilder.build());
            case HttpMethod.PATCH -> new HttpPatch(uriBuilder.build());
            case HttpMethod.GET -> new HttpGet(uriBuilder.build());
            case HttpMethod.DELETE -> new HttpDelete(uriBuilder.build());
        };
    }

    default public HttpPut createPutRequest(String url, Map<String, String> params) throws Exception {
        return this.createPutRequest(url, new HashMap<String, String>(), params, this.contentType());
    }

    default public HttpPut createPutRequest(String url, Map<String, String> headers, Map<String, String> params, String contentType) throws Exception {
        URIBuilder uriBuilder = new URIBuilder(url);
        uriBuilder.addParameters(this.getParametersAsList(params));
        HttpPut httpPut = new HttpPut(uriBuilder.build());
        if (ObjectChecker.areEqual((Object)contentType, (Object)ContentType.APPLICATION_FORM_URLENCODED.getMimeType())) {
            httpPut.setEntity((HttpEntity)new UrlEncodedFormEntity(this.getParametersAsList(params), StandardCharsets.UTF_8));
        }
        httpPut.setHeader(CONTENT_TYPE, (Object)contentType);
        for (Map.Entry<String, String> header : headers.entrySet()) {
            httpPut.addHeader(header.getKey(), (Object)header.getValue());
        }
        httpPut.setConfig(REQUESTS_CONFIG);
        return httpPut;
    }

    default public HttpDelete createDeleteRequest(String url, Map<String, String> params) throws Exception {
        URIBuilder uriBuilder = new URIBuilder(url);
        uriBuilder.addParameters(this.getParametersAsList(params));
        HttpDelete httpDelete = new HttpDelete(uriBuilder.build());
        httpDelete.setConfig(REQUESTS_CONFIG);
        return httpDelete;
    }

    default public HttpGet createGetRequest(String url, Map<String, String> headers, Map<String, String> params) {
        try {
            URIBuilder uriBuilder = new URIBuilder(url);
            uriBuilder.addParameters(this.getParametersAsList(params));
            HttpGet httpGet = new HttpGet(uriBuilder.build());
            for (Map.Entry<String, String> header : headers.entrySet()) {
                httpGet.addHeader(header.getKey(), (Object)header.getValue());
            }
            httpGet.setConfig(REQUESTS_CONFIG);
            return httpGet;
        }
        catch (Exception e) {
            throw new NaMaServiceExcepption((Throwable)e);
        }
    }

    default public List<NameValuePair> getParametersAsList(Map<String, String> params) {
        ArrayList<NameValuePair> postParameters = new ArrayList<NameValuePair>();
        if (params != null && params.size() > 0) {
            for (String key : params.keySet()) {
                postParameters.add((NameValuePair)new BasicNameValuePair(key, params.get(key)));
            }
        }
        return postParameters;
    }

    default public void checkValidResponse(CloseableHttpResponse httpResponse) {
        if (this.ifValidResponse((HttpResponse)httpResponse)) {
            return;
        }
        if (this.ifAPIError(httpResponse)) {
            return;
        }
        this.handleError(httpResponse);
    }

    default public void handleError(CloseableHttpResponse httpResponse) {
        String error = null;
        try {
            error = IOUtils.toString((InputStream)httpResponse.getEntity().getContent());
            this.mapper().readValue(error, Map.class);
        }
        catch (Exception e) {
            Source htmlSource;
            Source source = htmlSource = error == null ? null : new Source((CharSequence)error);
            if (htmlSource != null) {
                Segment htmlSeg = new Segment(htmlSource, 0, htmlSource.length());
                Renderer htmlRend = new Renderer(htmlSeg);
                throw new RuntimeException(MessageFormat.format("Error in HTTP Request: Status {0} - Error Details: {1} \nResponse: {2}", httpResponse.getCode(), httpResponse.getReasonPhrase(), htmlRend.toString()));
            }
            throw new RuntimeException(MessageFormat.format("Error in HTTP Request: Status {0} - Error Details: {1}", httpResponse.getCode(), httpResponse.getReasonPhrase()));
        }
        throw new RuntimeException(MessageFormat.format("Error in HTTP Request: Status {0} - Error Details: {1} \nResponse: {2}", httpResponse.getCode(), httpResponse.getReasonPhrase(), error));
    }

    default public <T> List<T> getListAndReleaseConnection(HttpUriRequestBase httpRequest, Class<T> objectClass) {
        List list;
        block9: {
            CloseableHttpResponse httpResponse = this.httpClient().execute((ClassicHttpRequest)httpRequest);
            try {
                HttpEntity httpEntity = httpResponse.getEntity();
                if (httpEntity == null) {
                    throw new RuntimeException("Error retrieving results from http request");
                }
                this.checkValidResponse(httpResponse);
                list = (List)this.mapper().readValue(httpEntity.getContent(), (JavaType)this.mapper().getTypeFactory().constructCollectionType(List.class, objectClass));
                if (httpResponse == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (httpResponse != null) {
                        try {
                            httpResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            httpResponse.close();
        }
        return list;
    }

    default public boolean ifValidResponse(HttpResponse response) {
        return ("" + response.getCode()).matches("[1-3]\\d\\d");
    }

    default public boolean ifAPIError(CloseableHttpResponse response) {
        return false;
    }

    public static class ResultAsSTR {
        public final String result;

        public ResultAsSTR(String result) {
            this.result = result;
        }
    }
}

