/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.httpcommon.oauth;

public final class OAuthConfig {
    private final String url;
    private final String consumerKey;
    private final String consumerSecret;

    public OAuthConfig(String url, String consumerKey, String consumerSecret) {
        if (url == null || url.isEmpty() || consumerKey == null || consumerKey.isEmpty() || consumerSecret == null || consumerSecret.isEmpty()) {
            throw new IllegalArgumentException("All arguments are required");
        }
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        this.url = url;
        this.consumerKey = consumerKey;
        this.consumerSecret = consumerSecret;
    }

    public String getUrl() {
        return this.url;
    }

    public String getConsumerKey() {
        return this.consumerKey;
    }

    public String getConsumerSecret() {
        return this.consumerSecret;
    }
}

