/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.erp.weightscale.application;

import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.erp.weightscale.controls.NamaControlType;
import com.namasoft.erp.weightscale.controls.NamaHBox;
import com.namasoft.erp.weightscale.controls.NamaLabeledControl;
import com.namasoft.erp.weightscale.controls.NamaVBox;
import com.namasoft.erp.weightscale.controls.NamaWeightGauge;
import com.namasoft.erp.weightscale.utils.WeightProcessInfo;
import com.namasoft.erp.weightscale.utils.WeightScaleMediaUtil;
import com.namasoft.erp.weightscale.utils.WeightScaleQuantity;
import com.namasoft.erp.weightscale.utils.WeightScaleUOM;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;

public class ScaleScreen
extends NamaHBox {
    private static final double ZERO = 0.0;
    private NamaLabeledControl<String> grossWeightLabel;
    private NamaLabeledControl<String> netWeightLabel;
    private NamaLabeledControl<String> tareLabel;
    private NamaLabeledControl<String> locatorLabel;
    private WeightProcessInfo weightProcessInfo = new WeightProcessInfo();
    private NamaWeightGauge gauge = new NamaWeightGauge();

    public void settings(Double requiredQtyVal, Double deviationVal, EntityReferenceData unit, Integer fractionDecimalPlaces, String locator) {
        WeightScaleUOM uom = WeightScaleUOM.parse(unit);
        fractionDecimalPlaces = ObjectChecker.getFirstNotEmptyOrZero((Integer[])new Integer[]{fractionDecimalPlaces, 2});
        this.weightProcessInfo.init(uom, fractionDecimalPlaces);
        this.gauge.updateMinAndMaxWeight(requiredQtyVal, requiredQtyVal + deviationVal, uom);
        this.gauge.setDecimals(fractionDecimalPlaces);
        this.gauge.setUnit(unit.getCode());
        this.updatePackageWeight();
        this.locatorLabel.insertValue(locator);
    }

    public void updateGrossWeightAction() {
        this.grossWeightLabel.insertValue(this.weightProcessInfo.getGrossWeight().toString());
    }

    public void updateNetWeightAction() {
        this.netWeightLabel.insertValue(this.weightProcessInfo.getNetWeight().toString());
        this.updateGrossWeightAction();
    }

    public void tareAction() {
        this.weightProcessInfo.tare();
        this.updateNetWeight(this.weightProcessInfo.getNetWeight().getQty(), ObjectChecker.toStringOrEmpty((Object)((Object)this.weightProcessInfo.getNetWeight().getUom())));
        this.updatePackageWeight();
    }

    public void updatePackageWeight() {
        if (ObjectChecker.isObjectNotEmptyOrZero((Object)this.weightProcessInfo.getPackageWeight().getQty())) {
            this.gauge.setActivateValidation(true);
        } else {
            this.gauge.setActivateValidation(false);
        }
        this.tareLabel.insertValue(this.weightProcessInfo.getPackageWeight().toString());
    }

    public ScaleScreen(double screenWidth) {
        this.setId("mainContainer");
        this.netWeightLabel = this.createScaleScreenLabel("netWeight");
        this.grossWeightLabel = this.createScaleScreenLabel("grossWeight");
        this.tareLabel = this.createScaleScreenLabel("tare");
        this.locatorLabel = this.createScaleScreenLabel("locator");
        NamaVBox weightSubBox = new NamaVBox(new Node[0]);
        weightSubBox.setId("weightInputSection");
        weightSubBox.getChildren().addAll((Object[])new Node[]{this.grossWeightLabel, this.tareLabel, this.netWeightLabel, this.locatorLabel});
        weightSubBox.getChildren().forEach(child -> NamaVBox.setVgrow((Node)child, (Priority)Priority.ALWAYS));
        StackPane stackPane = new StackPane(new Node[]{this.gauge});
        stackPane.setAlignment(Pos.CENTER);
        stackPane.getStyleClass().add((Object)"gauge-container");
        NamaHBox.setHgrow((Node)stackPane, (Priority)Priority.ALWAYS);
        this.getChildren().addAll((Object[])new Node[]{weightSubBox, stackPane});
    }

    private NamaLabeledControl<String> createScaleScreenLabel(String tare) {
        NamaLabeledControl<String> labeledControl = new NamaLabeledControl<String>(tare, NamaControlType.Label);
        labeledControl.getStyleClass().add((Object)"weight-label");
        labeledControl.cssId("weightDisplay");
        return labeledControl;
    }

    public void updateNetWeight(double weight, String unit) {
        this.weightProcessInfo.updateNetWeight(weight, unit);
        this.gauge.update(this.weightProcessInfo.getNetWeight());
        this.updateNetWeightAction();
    }

    public void zero() {
        this.weightProcessInfo.zero();
        this.updatePackageWeight();
        this.reset();
        WeightScaleMediaUtil.stopPlayer();
    }

    public void reset() {
        this.updateNetWeight(0.0, "");
        this.locatorLabel.insertValue("");
        WeightScaleMediaUtil.stopPlayer();
    }

    public WeightScaleQuantity getMinWeight() {
        return this.gauge.getMinWeight();
    }

    public WeightScaleQuantity getMaxWeight() {
        return this.gauge.getMaxWeight();
    }

    public Double getNetWeight() {
        return this.weightProcessInfo.getNetWeight().getQty();
    }

    public Double getPackageWeight() {
        return this.weightProcessInfo.getPackageWeight().getQty();
    }

    public Double getGrossWeight() {
        return this.weightProcessInfo.getGrossWeight().getQty();
    }
}

