/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.erp.weightscale.application;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.erp.guiserver.ServiceLoginProvider;
import com.namasoft.erp.weightscale.controls.NamaButton;
import com.namasoft.erp.weightscale.controls.NamaControlType;
import com.namasoft.erp.weightscale.controls.NamaHBox;
import com.namasoft.erp.weightscale.controls.NamaLabeledControl;
import com.namasoft.erp.weightscale.controls.NamaVBox;
import com.namasoft.erp.weightscale.utils.ServiceProvider;
import com.namasoft.erp.weightscale.utils.WeightScaleGeneralSettings;
import com.namasoft.erp.weightscale.utils.WeightScaleResult;
import com.namasoft.erp.weightscale.utils.WeightScaleScreen;
import com.namasoft.erp.weightscale.utils.WeightScaleTranslator;
import com.namasoft.erp.weightscale.utils.WeightScaleUtils;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;

public class WeightScaleLoginScreen
extends NamaVBox {
    private NamaLabeledControl<String> userName;
    private NamaLabeledControl<String> password;
    private NamaButton login;
    private NamaButton exit;
    private Label titleLabel;
    private NamaVBox formContainer;
    private NamaHBox buttonContainer;

    public WeightScaleLoginScreen() {
        super(new Node[0]);
        this.setId("mainContainer");
        this.setAlignment(Pos.CENTER);
        this.setMaxWidth(450.0);
        this.titleLabel = new Label(WeightScaleTranslator.translate("weightScale", new Object[0]));
        this.titleLabel.getStyleClass().add((Object)"label");
        this.titleLabel.setId("weightDisplay");
        this.titleLabel.setAlignment(Pos.CENTER);
        this.formContainer = new NamaVBox(new Node[0]);
        this.formContainer.setId("formContainer");
        this.formContainer.setAlignment(Pos.CENTER);
        this.userName = new NamaLabeledControl("userName", NamaControlType.TextField);
        this.userName.setAlignment(Pos.CENTER);
        this.userName.getControl().requestFocus();
        this.userName.addEventHandler(KeyEvent.ANY, e -> {
            if (ObjectChecker.areEqual((Object)e.getCode(), (Object)KeyCode.ENTER)) {
                this.password.requestFocus();
            }
        });
        this.password = new NamaLabeledControl("password", NamaControlType.PasswordField);
        this.password.setAlignment(Pos.CENTER);
        this.password.setOnKeyPressed(e -> {
            if (ObjectChecker.areNotEqual((Object)e.getCode(), (Object)KeyCode.ENTER)) {
                return;
            }
            this.login();
        });
        this.formContainer.getChildren().addAll((Object[])new Node[]{this.userName, this.password});
        this.buttonContainer = new NamaHBox();
        this.buttonContainer.setAlignment(Pos.CENTER);
        this.login = new NamaButton("login");
        this.login.setId("login");
        this.login.setOnAction(e -> this.login());
        this.exit = new NamaButton("exit");
        this.exit.setId("exit");
        this.exit.setOnAction(e -> System.exit(0));
        this.buttonContainer.getChildren().addAll((Object[])new Node[]{this.login, this.exit});
        Region topSpacer = new Region();
        Region bottomSpacer = new Region();
        NamaVBox.setVgrow((Node)topSpacer, (Priority)Priority.ALWAYS);
        NamaVBox.setVgrow((Node)bottomSpacer, (Priority)Priority.ALWAYS);
        this.getChildren().addAll((Object[])new Node[]{topSpacer, this.titleLabel, this.formContainer, this.buttonContainer, bottomSpacer});
    }

    private void login() {
        WeightScaleResult result = this.authenticate();
        if (result.succeded()) {
            WeightScaleUtils.username = this.userName.fetchValue();
            WeightScaleUtils.password = this.password.fetchValue();
            this.userName.reset();
            this.password.reset();
            WeightScaleUtils.user = ServiceLoginProvider.getDTOUser() == null ? "Undefined" : ServiceLoginProvider.getDTOUser().getName1();
            WeightScaleUtils.drawScreen(WeightScaleScreen.WeightScaleScreen);
            WeightScaleUtils.stage.setTitle(WeightScaleTranslator.translate("weightScale", new Object[0]).concat("        ").concat(WeightScaleUtils.calcAppVersion()));
        } else {
            WeightScaleUtils.showError(result);
        }
    }

    private WeightScaleResult authenticate() {
        WeightScaleResult result = new WeightScaleResult();
        try {
            if (ServiceProvider.connectionIsDown()) {
                result.failure("Can not connect to server", new Object[0]);
            }
            if (!result.isFailed()) {
                ServiceLoginProvider.login((String)WeightScaleGeneralSettings.getServerURL(), (String)this.password.fetchValue(), (String)this.userName.fetchValue());
            }
        }
        catch (Exception exception) {
            result.failure("Login failed", new Object[0]);
        }
        return result;
    }
}

