/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.erp.weightscale.controls;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.erp.weightscale.utils.WeightScaleMediaUtil;
import com.namasoft.erp.weightscale.utils.WeightScaleQuantity;
import com.namasoft.erp.weightscale.utils.WeightScaleTranslator;
import com.namasoft.erp.weightscale.utils.WeightScaleUOM;
import eu.hansolo.medusa.Gauge;
import javafx.geometry.Pos;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class NamaWeightGauge
extends Gauge {
    private static final double ZERO = 0.0;
    private WeightGaugeStatus status = WeightGaugeStatus.Less;
    private WeightScaleQuantity minWeight = new WeightScaleQuantity();
    private WeightScaleQuantity maxWeight = new WeightScaleQuantity();
    private boolean activateValidation = false;

    public NamaWeightGauge() {
        this.setKnobPosition(Pos.CENTER);
        this.setBarColor(Color.CYAN);
        this.setBackgroundPaint((Paint)Color.TRANSPARENT);
        this.setTitleColor(Gauge.DARK_COLOR);
        this.setValueColor(Gauge.DARK_COLOR);
        this.setUnitColor(Gauge.DARK_COLOR);
        this.setBorderPaint((Paint)Color.rgb((int)208, (int)208, (int)208));
        this.setDecimals(0);
        this.setStartFromZero(true);
        this.setTitle(WeightScaleTranslator.translate("Weight", new Object[0]));
        this.setUnit("kg");
        this.setMinValue(0.0);
        this.setSkinType(Gauge.SkinType.FLAT);
        this.setMinSize(200.0, 200.0);
        this.setBarColor(Color.valueOf((String)"#F8FF00"));
        this.setValueVisible(true);
    }

    public void update(WeightScaleQuantity quantity) {
        if (this.activateValidation) {
            this.validateQty(quantity);
        }
        this.setValue(quantity.getQty());
    }

    private void validateQty(WeightScaleQuantity quantity) {
        if (this.isExact(quantity)) {
            this.applyEffects(WeightGaugeStatus.Exact);
        } else if (this.isExceed(quantity)) {
            this.applyEffects(WeightGaugeStatus.Exceed);
        } else if (this.isLess(quantity) || quantity.getQty() <= 0.0) {
            this.applyEffects(WeightGaugeStatus.Less);
        }
    }

    private boolean isExact(WeightScaleQuantity quantity) {
        return quantity.compareTo(this.minWeight) >= 0 && quantity.compareTo(this.maxWeight) <= 0;
    }

    private boolean isExceed(WeightScaleQuantity quantity) {
        return quantity.compareTo(this.maxWeight) > 0;
    }

    private boolean isLess(WeightScaleQuantity quantity) {
        return quantity.compareTo(this.minWeight) < 0;
    }

    private void applyEffects(WeightGaugeStatus newStatus) {
        if (ObjectChecker.areEqual((Object)((Object)this.status), (Object)((Object)newStatus))) {
            return;
        }
        this.status = newStatus;
        if (ObjectChecker.areEqual((Object)((Object)newStatus), (Object)((Object)WeightGaugeStatus.Exact))) {
            this.setBarColor(Color.valueOf((String)"#04fb7a"));
            WeightScaleMediaUtil.playReachWeightSound();
        } else if (ObjectChecker.areEqual((Object)((Object)newStatus), (Object)((Object)WeightGaugeStatus.Exceed))) {
            this.setBarColor(Color.valueOf((String)"#df2c2c"));
            WeightScaleMediaUtil.playAlert();
        } else if (ObjectChecker.areEqual((Object)((Object)newStatus), (Object)((Object)WeightGaugeStatus.Less))) {
            this.setBarColor(Color.valueOf((String)"#F8FF00"));
            WeightScaleMediaUtil.stopPlayer();
        }
    }

    public void updateMinAndMaxWeight(Double minWeight, Double maxWeight, WeightScaleUOM uom) {
        this.minWeight.setQty(minWeight);
        this.minWeight.setUom(uom);
        this.maxWeight.setQty(maxWeight);
        this.maxWeight.setUom(uom);
        this.setMaxValue(maxWeight);
    }

    public WeightScaleQuantity getMinWeight() {
        return this.minWeight;
    }

    public WeightScaleQuantity getMaxWeight() {
        return this.maxWeight;
    }

    public void setActivateValidation(boolean activateValidation) {
        this.activateValidation = activateValidation;
    }

    public String getUserAgentStylesheet() {
        return ((Object)((Object)this)).getClass().getClassLoader().getResource("gauge.css").toExternalForm();
    }

    private static enum WeightGaugeStatus {
        Less,
        Exact,
        Exceed;

    }
}

