/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.erp.weightscale.utils;

import com.namasoft.common.utilities.Callback;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.erp.weightscale.utils.ScaleAPI;
import com.namasoft.erp.weightscale.utils.WeightScaleConnector;
import com.namasoft.erp.weightscale.utils.WeightScaleHandler;
import com.namasoft.erp.weightscale.utils.WeightScaleUtils;
import java.util.function.BiConsumer;

public class ScaleAPIImpl
implements ScaleAPI {
    private WeightScaleConnector weightScaleConnector;
    private static ScaleAPI scale = new ScaleAPIImpl();

    public static ScaleAPI getInstance() {
        return scale;
    }

    private ScaleAPIImpl() {
    }

    @Override
    public void connect() {
        this.weightScaleConnector = new WeightScaleConnector();
        this.weightScaleConnector.open(ScaleAPIImpl.fetchPortNumber());
        this.write("@");
        this.write("@");
        this.write("B00");
        this.zero();
        this.serialNumber();
        this.listening();
    }

    @Override
    public void powerOn() {
        this.write("PWR 1");
    }

    @Override
    public void serialNumber() {
        this.write("I4");
    }

    public void setSerialNumberCallback(Callback callback) {
        WeightScaleHandler.serialNumberCallBack = callback;
    }

    private void write(String c) {
        this.weightScaleConnector.write(c);
    }

    private void listening() {
        this.weightScaleConnector.listening();
    }

    private static String fetchPortNumber() {
        return (String)ObjectChecker.getFirstNotEmptyObj((Object[])new String[]{WeightScaleUtils.fetchPortNumber(), "COM1"});
    }

    @Override
    public void measure() {
        this.write("SIRU");
    }

    @Override
    public void cancel() {
        this.write("S");
    }

    @Override
    public void setMeasureCallback(BiConsumer<Float, String> callback) {
        WeightScaleHandler.weightScaleMeasurementCB = callback;
    }

    @Override
    public void tare() {
        this.write("T");
    }

    @Override
    public void setTareCallback(Callback callback) {
        WeightScaleHandler.weightScaleTareCB = callback;
    }

    @Override
    public void zero() {
        this.cancel();
        this.write("Z");
    }

    @Override
    public void setZeroCallback(Callback callback) {
        WeightScaleHandler.weightScaleZeroCB = callback;
    }

    @Override
    public void disconnect() {
        this.cancel();
        if (this.weightScaleConnector != null) {
            this.weightScaleConnector.close();
        }
    }

    @Override
    public void reconnect() {
        this.disconnect();
        this.connect();
    }
}

