/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.erp.weightscale.utils;

import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.erp.weightscale.utils.WeightScaleHandler;
import com.namasoft.erp.weightscale.utils.WeightScaleTranslator;
import javafx.application.Platform;
import javafx.scene.control.Alert;
import javafx.stage.Modality;
import jssc.SerialPort;
import jssc.SerialPortException;

public class WeightScaleConnector {
    private SerialPort serialPort;

    public void open(String portName) {
        try {
            this.serialPort = new SerialPort(portName);
            NaMaLogger.info((String)"Current Active COMM Port is {0}", (Object[])new Object[]{this.serialPort.getPortName()});
            this.serialPort.openPort();
            this.serialPort.setParams(9600, 8, 1, 0);
        }
        catch (SerialPortException e) {
            throw new RuntimeException(WeightScaleTranslator.translate(e.getMessage(), new Object[0]));
        }
    }

    private static void showAlertWithMsg(String msg) {
        Platform.runLater(() -> {
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setHeaderText("Error");
            alert.initModality(Modality.WINDOW_MODAL);
            alert.setContentText(msg);
            alert.show();
        });
    }

    public void write(String cmd) {
        NaMaLogger.info((String)"Writing {0} to {1} ", (Object[])new Object[]{cmd, this.serialPort.getPortName()});
        try {
            if (this.serialPort == null) {
                throw new RuntimeException("Serial port is null");
            }
            if (!this.serialPort.isOpened()) {
                throw new RuntimeException("Please check the connection");
            }
            this.serialPort.writeBytes(cmd.getBytes());
            this.serialPort.writeBytes("\r".getBytes());
            this.serialPort.writeBytes("\n".getBytes());
        }
        catch (Exception e) {
            throw new RuntimeException(WeightScaleTranslator.translate(e.getMessage(), new Object[0]));
        }
    }

    public void listening() {
        if (this.serialPort == null) {
            throw new RuntimeException("Serial port is null");
        }
        NaMaLogger.info((String)"Reading from {0}", (Object[])new Object[]{this.serialPort.getPortName()});
        try {
            this.serialPort.setEventsMask(1);
        }
        catch (SerialPortException e) {
            throw new RuntimeException(WeightScaleTranslator.translate(e.getMessage(), new Object[0]));
        }
        try {
            this.serialPort.addEventListener(event -> {
                if (event.isRXCHAR()) {
                    try {
                        int eventValue = event.getEventValue();
                        NaMaLogger.info((Object)eventValue);
                        byte[] buffer = this.serialPort.readBytes(eventValue);
                        for (int i = 0; i < buffer.length && i < eventValue; ++i) {
                            WeightScaleHandler.metosi_read((char)buffer[i]);
                        }
                    }
                    catch (SerialPortException e) {
                        throw new RuntimeException(WeightScaleTranslator.translate(e.getMessage(), new Object[0]));
                    }
                }
            });
        }
        catch (SerialPortException e) {
            NaMaLogger.error((Throwable)e);
        }
    }

    public void close() {
        try {
            if (this.serialPort != null) {
                this.serialPort.closePort();
            }
        }
        catch (Exception e) {
            NaMaLogger.error((Throwable)e);
        }
    }
}

