/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.erp.weightscale.utils;

import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.erp.weightscale.utils.WeightScaleResult;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyEvent;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Duration;

public class WeightScaleErrorAndInfoMessagesUtil {
    private static Tooltip errorTooltip;
    private static Tooltip infoTooltip;
    private static Timeline timer;

    public static void showError(WeightScaleResult result, Stage stage) {
        WeightScaleErrorAndInfoMessagesUtil.initTooltipAndTimeIfNeeded();
        WeightScaleErrorAndInfoMessagesUtil.show(errorTooltip, result, stage);
    }

    public static void showError(String message, Stage stage) {
        WeightScaleErrorAndInfoMessagesUtil.initTooltipAndTimeIfNeeded();
        WeightScaleResult posResult = new WeightScaleResult();
        posResult.failure(message, new Object[0]);
        WeightScaleErrorAndInfoMessagesUtil.show(errorTooltip, posResult, stage);
    }

    public static void showInfo(WeightScaleResult result, Stage stage) {
        WeightScaleErrorAndInfoMessagesUtil.initTooltipAndTimeIfNeeded();
        WeightScaleErrorAndInfoMessagesUtil.show(infoTooltip, result, stage);
    }

    private static void show(Tooltip toolTip, WeightScaleResult result, Stage stage) {
        StringBuilder message = new StringBuilder(WeightScaleErrorAndInfoMessagesUtil.resultToMessage(result));
        if (stage == null) {
            NaMaLogger.error((String)"Can not show error because stage not yet initialized: {0}", (Object[])new Object[]{message});
            return;
        }
        if (toolTip.isShowing()) {
            message.insert(0, toolTip.getText());
        }
        toolTip.setText(message.toString());
        toolTip.show((Window)stage);
        timer.playFromStart();
    }

    private static void initTooltipAndTimeIfNeeded() {
        if (errorTooltip != null) {
            return;
        }
        errorTooltip = WeightScaleErrorAndInfoMessagesUtil.createTooltip("error-tooltip");
        infoTooltip = WeightScaleErrorAndInfoMessagesUtil.createTooltip("info-tooltip");
        timer = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)5.0), event -> {
            errorTooltip.hide();
            infoTooltip.hide();
        }, new KeyValue[0])});
    }

    private static Tooltip createTooltip(String styleClass) {
        Tooltip tooltip = new Tooltip("");
        tooltip.setAutoFix(true);
        tooltip.setAutoHide(true);
        tooltip.setHideOnEscape(true);
        tooltip.getStyleClass().add((Object)styleClass);
        tooltip.addEventHandler(KeyEvent.KEY_PRESSED, e -> tooltip.hide());
        return tooltip;
    }

    private static String resultToMessage(WeightScaleResult result) {
        return result.getArMessage();
    }
}

