/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.erp.weightscale.utils;

import com.namasoft.common.utilities.Callback;
import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.erp.weightscale.utils.WeightScaleUtils;
import java.util.function.BiConsumer;
import javafx.application.Platform;

public class WeightScaleHandler {
    public static final int SCALE_FINE_E = 0;
    public static final int SCALE_HIGH_E = 1;
    public static final int SCALE_LOW_E = 2;
    public static final int SCALE_INIT_E = 3;
    public static final int SCALE_COM_E = 4;
    public static final int SCALE_TARE_E = 5;
    public static final int SCALE_TARE_LOW_E = 6;
    public static final int SCALE_TARE_HIGH_E = 7;
    public static final int SCALE_ZERO_E = 8;
    public static final int SCALE_ZERO_LOW_E = 9;
    public static final int SCALE_ZERO_HIGH_E = 10;
    public static final String SCALE_TARE_CMD = "T";
    public static final String SCALE_MEASURE_CMD = "S";
    public static final String SCALE_CONTINUOUSMEASURE_CMD = "SIRU";
    public static final String SCALE_DISPLAY_CMD = "D";
    public static final String SCALE_DISPLAY_WEIGHT_CMD = "DW";
    public static final String SCALE_ZERO_CMD = "Z";
    public static final String SCALE_RESET_CMD = "@";
    public static final String SCALE_POWER_OFF_CMD = "PWR 0";
    public static final String SCALE_POWER_ON_CMD = "PWR 1";
    public static final String SCALE_INIT = "I4";
    public static final String SCALE_POWER_RESPONSE = "PWR A";
    public static final String SCALE_OK = "EL";
    public static final String SCALE_SYNTAX_EROR = "ES";
    public static final String SCALE_DISPLAY_OK = "D A";
    public static final String SCALE_MEASURE_STABLE = "S S";
    public static final String SCALE_MEASURE_UNSTABLE = "S D";
    public static final String SCALE_MEASURE_HIGH = "S +";
    public static final String SCALE_MEASURE_LOW = "S -";
    public static final String SCALE_BUSY = "S I";
    public static final String SCALE_ERROR = "E";
    public static final String SCALE_TARE_OKAY = "T S";
    public static final String SCALE_TARE_HIGH = "T +";
    public static final String SCALE_TARE_LOW = "T -";
    public static final String SCALE_TARE_ERROR = "T I";
    public static final String SCALE_ZERO_OK = "Z A";
    public static final String SCALE_ZERO_HIGH = "Z +";
    public static final String SCALE_ZERO_LOW = "Z -";
    public static final String SCALE_ZERO_ERROR = "Z I";
    private static final char LF = '\n';
    private static final char SPACE = ' ';
    private static final int BUFF_SIZE = 1024;
    private static StringBuilder rcv_buff = new StringBuilder();
    private static float measurement = 0.0f;
    private static int decimal_shift = 0;
    private static char[] unit = new char[8];
    private static int serial_number = 0;
    public static BiConsumer<Float, String> weightScaleMeasurementCB;
    public static Callback<Object> weightScaleTareCB;
    public static Callback<Object> weightScaleZeroCB;
    public static Callback<Integer> serialNumberCallBack;

    public static void metosi_read(char c) {
        rcv_buff.append(c);
        if (c == '\n') {
            int i;
            String currentLine = rcv_buff.toString();
            if (currentLine.startsWith(SCALE_INIT)) {
                serial_number = 0;
                i = 0;
                while (currentLine.charAt(i) != '\"') {
                    ++i;
                }
                while (currentLine.charAt(++i) != '\"') {
                    serial_number *= 10;
                    serial_number += currentLine.charAt(i) - 48;
                }
                WeightScaleHandler.metosi_serialnumber_cb(serial_number);
            }
            if (currentLine.startsWith(SCALE_BUSY)) {
                WeightScaleHandler.metosi_scale_busy_cb();
            }
            if (currentLine.startsWith(SCALE_MEASURE_STABLE) || currentLine.startsWith(SCALE_MEASURE_UNSTABLE)) {
                WeightScaleUtils.isStableWeightFlag = ObjectChecker.isTrue((Boolean)currentLine.startsWith(SCALE_MEASURE_STABLE));
                measurement = 0.0f;
                decimal_shift = 0;
                i = SCALE_MEASURE_STABLE.length();
                while (currentLine.charAt(i) == ' ') {
                    ++i;
                }
                while (currentLine.charAt(i) != ' ') {
                    if (currentLine.charAt(i) == '.') {
                        decimal_shift = i;
                    }
                    if (currentLine.charAt(i) == '-' || currentLine.charAt(i) == '.') {
                        ++i;
                    }
                    measurement *= 10.0f;
                    measurement += (float)(currentLine.charAt(i) - 48);
                    ++i;
                }
                if (currentLine.contains("-")) {
                    measurement *= -1.0f;
                }
                if (ObjectChecker.isNotEmptyOrZero((Integer)decimal_shift)) {
                    decimal_shift = i - 1 - decimal_shift;
                    measurement = (float)((double)measurement / Math.pow(10.0, decimal_shift));
                }
                while (currentLine.charAt(i) == ' ') {
                    ++i;
                }
                int j = 0;
                while (currentLine.charAt(i) != '\n') {
                    WeightScaleHandler.unit[j++] = currentLine.charAt(i++);
                }
                WeightScaleHandler.unit[j + 1] = '\u0000';
                WeightScaleHandler.metosi_measurement_cb(0, measurement, unit);
            }
            if (currentLine.startsWith(SCALE_MEASURE_HIGH)) {
                WeightScaleHandler.metosi_measurement_cb(1, 0.0f, null);
            }
            if (currentLine.startsWith(SCALE_MEASURE_LOW)) {
                WeightScaleHandler.metosi_measurement_cb(2, 0.0f, null);
            }
            if (currentLine.startsWith(SCALE_ERROR) || ObjectChecker.isEmptyOrNull((Object)currentLine)) {
                WeightScaleHandler.metosi_measurement_cb(4, 0.0f, null);
            }
            if (currentLine.startsWith(SCALE_TARE_OKAY)) {
                WeightScaleHandler.metosi_tare_cb(0);
            }
            if (currentLine.startsWith(SCALE_TARE_HIGH)) {
                WeightScaleHandler.metosi_tare_cb(7);
            }
            if (currentLine.startsWith(SCALE_TARE_LOW)) {
                WeightScaleHandler.metosi_tare_cb(7);
            }
            if (currentLine.startsWith(SCALE_TARE_ERROR)) {
                WeightScaleHandler.metosi_tare_cb(5);
            }
            if (currentLine.startsWith(SCALE_ZERO_OK)) {
                WeightScaleHandler.metosi_zero_cb(0);
            }
            if (currentLine.startsWith(SCALE_ZERO_HIGH)) {
                WeightScaleHandler.metosi_zero_cb(10);
            }
            if (currentLine.startsWith(SCALE_ZERO_LOW)) {
                WeightScaleHandler.metosi_zero_cb(9);
            }
            if (currentLine.startsWith(SCALE_ZERO_ERROR)) {
                WeightScaleHandler.metosi_zero_cb(8);
            }
            NaMaLogger.info((Object)rcv_buff.toString());
            rcv_buff = new StringBuilder();
            unit = new char[8];
        }
    }

    private static void metosi_scale_busy_cb() {
        Platform.runLater(() -> WeightScaleUtils.showError("Scale reports busy/off"));
    }

    private static void metosi_measurement_cb(int res, float weight, char[] unit) {
        Runnable runnable = null;
        switch (res) {
            case 0: {
                runnable = () -> {
                    if (weightScaleMeasurementCB != null) {
                        weightScaleMeasurementCB.accept(Float.valueOf(weight), String.valueOf(unit));
                    }
                };
                break;
            }
            case 1: {
                runnable = () -> WeightScaleUtils.showError("Scale weight is too high");
                break;
            }
            case 2: {
                runnable = () -> WeightScaleUtils.showError("Please press zero button");
                break;
            }
            case 4: {
                runnable = () -> WeightScaleUtils.showError("Scale communication error");
                break;
            }
            default: {
                runnable = () -> WeightScaleUtils.showError("unknown error:\t");
            }
        }
        Platform.runLater((Runnable)runnable);
    }

    private static void metosi_tare_cb(int res) {
        Platform.runLater((Runnable)(switch (res) {
            case 0 -> () -> weightScaleTareCB.done(null);
            case 7 -> () -> WeightScaleUtils.showError("Scale weight is too high to tare");
            case 6 -> () -> WeightScaleUtils.showError("Scale weight is too low to tare");
            case 5 -> () -> WeightScaleUtils.showError("Scale tare error");
            default -> () -> WeightScaleUtils.showError("Unknown error:\t");
        }));
    }

    private static void metosi_zero_cb(int res) {
        Platform.runLater((Runnable)(switch (res) {
            case 0 -> () -> weightScaleZeroCB.done(null);
            case 10 -> () -> WeightScaleUtils.showError("Please press zero button");
            case 9 -> () -> WeightScaleUtils.showError("Please press zero button");
            case 8 -> () -> WeightScaleUtils.showError("Scale tare error");
            default -> () -> WeightScaleUtils.showError("Unknown error:\t");
        }));
    }

    private static void metosi_serialnumber_cb(int serialNumber) {
        serialNumberCallBack.done((Object)serialNumber);
    }

    static {
        weightScaleTareCB = Callback.NULL;
        weightScaleZeroCB = Callback.NULL;
        serialNumberCallBack = Callback.NULL;
    }
}

