/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.erp.weightscale.utils;

import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.erp.weightscale.utils.WeightScaleUOM;

public class WeightScaleQuantity {
    private Double qty = 0.0;
    private WeightScaleUOM uom = WeightScaleUOM.G;

    public WeightScaleQuantity() {
    }

    public WeightScaleQuantity(Double qty, EntityReferenceData uom) {
        this.qty = qty == null ? 0.0 : qty;
        this.uom = WeightScaleUOM.parse(uom);
    }

    public Double getQty() {
        return this.qty;
    }

    public void setQty(Double qty) {
        this.qty = qty;
    }

    public WeightScaleUOM getUom() {
        return this.uom;
    }

    public void setUom(WeightScaleUOM uom) {
        this.uom = uom;
    }

    public void setUomAndConvert(WeightScaleUOM uom) {
        if (this.uom == null || ObjectChecker.areEqual((Object)((Object)uom), (Object)((Object)this.uom))) {
            return;
        }
        if (ObjectChecker.areEqual((Object)((Object)uom), (Object)((Object)WeightScaleUOM.KG))) {
            this.toKG();
        } else {
            this.toGram();
        }
        this.uom = uom;
    }

    public void toGram() {
        if (ObjectChecker.areEqual((Object)((Object)this.uom), (Object)((Object)WeightScaleUOM.G))) {
            return;
        }
        this.qty = this.qty * 1000.0;
        this.uom = WeightScaleUOM.G;
    }

    public void toKG() {
        if (ObjectChecker.areEqual((Object)((Object)this.uom), (Object)((Object)WeightScaleUOM.KG))) {
            return;
        }
        this.qty = this.qty / 1000.0;
        this.uom = WeightScaleUOM.KG;
    }

    public int compareTo(WeightScaleQuantity another) {
        return this.compareTo(another.qty, another.uom.toString());
    }

    public int compareTo(Double qty, String uom) {
        if (ObjectChecker.areEqual((Object)this.uom.toString(), (Object)uom)) {
            return this.qty.compareTo(qty);
        }
        if (uom.equalsIgnoreCase("kg")) {
            Double v = this.qty / 1000.0;
            return v.compareTo(qty);
        }
        Double v = this.qty * 1000.0;
        return v.compareTo(qty);
    }

    public Double plus(WeightScaleQuantity another) {
        if (ObjectChecker.areEqual((Object)((Object)this.uom), (Object)((Object)another.uom))) {
            return this.qty + another.qty;
        }
        if (ObjectChecker.areEqual((Object)((Object)this.uom), (Object)((Object)WeightScaleUOM.KG))) {
            return this.qty + another.qty / 1000.0;
        }
        return this.qty + another.qty * 1000.0;
    }

    public String toString() {
        return this.qty + " " + String.valueOf((Object)this.uom);
    }
}

