/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.erp.weightscale.utils;

import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utilities.StringUtils;

public enum WeightScaleUOM {
    KG,
    G;


    public static WeightScaleUOM parse(String unit) {
        if (ObjectChecker.isEmptyOrNull((Object)unit)) {
            return null;
        }
        return unit.trim().equalsIgnoreCase("kg") ? KG : G;
    }

    public static WeightScaleUOM parse(EntityReferenceData unit) {
        if (ObjectChecker.isEmptyOrNull((Object)unit)) {
            return null;
        }
        String taxAuthCode = ObjectChecker.toStringOrEmpty((Object)unit.get("taxAuthorityCode"));
        NaMaLogger.info((Object)(unit.getCode() + "--" + unit.getAltCode() + "--" + taxAuthCode));
        boolean isKG = StringUtils.isAnyEqualIgnoreCaseToFirst((String)"kg", (String[])new String[]{unit.getCode().trim(), unit.getAltCode().trim(), taxAuthCode.trim()});
        NaMaLogger.info((Object)("Is KG? " + isKG));
        return isKG ? KG : G;
    }
}

