/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.erp.weightscale.utils;

import com.namasoft.common.Pair;
import com.namasoft.common.exceptions.NaMaServiceExcepption;
import com.namasoft.common.utilities.Callback;
import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utils.ServerStringUtils;
import com.namasoft.erp.weightscale.application.WeightScaleLoginScreen;
import com.namasoft.erp.weightscale.application.WeightScaleMainScreen;
import com.namasoft.erp.weightscale.utils.ScaleAPIImpl;
import com.namasoft.erp.weightscale.utils.ServiceProvider;
import com.namasoft.erp.weightscale.utils.WeightScaleErrorAndInfoMessagesUtil;
import com.namasoft.erp.weightscale.utils.WeightScaleGeneralSettings;
import com.namasoft.erp.weightscale.utils.WeightScaleResult;
import com.namasoft.erp.weightscale.utils.WeightScaleScreen;
import com.namasoft.erp.weightscale.utils.WeightScaleTranslator;
import com.namasoft.modules.supplychain.contracts.DTOFetchWeightScaleConfigResult;
import com.namasoft.printingcommon.utils.NamaPDFPrintUtil;
import java.awt.print.PrinterException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javafx.beans.property.SimpleStringProperty;
import javafx.scene.Parent;
import javafx.scene.layout.Pane;
import javafx.stage.Screen;
import javafx.stage.Stage;

public class WeightScaleUtils {
    public static double screenWidth = Screen.getPrimary().getVisualBounds().getWidth() / 1.7;
    public static double screenHeight = Screen.getPrimary().getVisualBounds().getHeight() / 1.6;
    public static Stage stage;
    public static String username;
    public static String password;
    public static String user;
    public static boolean isStableWeightFlag;
    public static DTOFetchWeightScaleConfigResult config;
    public static SimpleStringProperty serialNumber;
    public static String DISCONNECTED;
    private static Map<WeightScaleScreen, Pane> cachedScreensMap;

    public static void setup() throws NaMaServiceExcepption {
        config = ServiceProvider.getInstance().fetchConfiguration();
        ScaleAPIImpl.getInstance().setSerialNumberCallback((Callback<Integer>)((Callback)no -> {
            NaMaLogger.info((Object)("Serial number is: " + no));
            try {
                serialNumber.setValue("" + no);
            }
            catch (Exception e) {
                serialNumber.set("");
            }
        }));
        ScaleAPIImpl.getInstance().connect();
    }

    public static String fetchPortNumber() {
        return (String)ObjectChecker.getFirstNotEmptyObj((Object[])new String[]{WeightScaleGeneralSettings.getWeightScalePort(), config.getPortNumber()});
    }

    public static String fetchPrinterName() {
        return (String)ObjectChecker.getFirstNotEmptyObj((Object[])new String[]{WeightScaleGeneralSettings.getPrinterName(), config.getPrinterName()});
    }

    public static void printSticker(Pair<String, String> lastLineTempPrintIdPair, WeightScaleResult result) {
        if (ObjectChecker.isEmptyOrNull(lastLineTempPrintIdPair) || ObjectChecker.isAnyEmptyOrNull((Object[])new Object[]{lastLineTempPrintIdPair.getX(), lastLineTempPrintIdPair.getY()})) {
            return;
        }
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("url", WeightScaleGeneralSettings.getGuiServerURL());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("user", (String)ObjectChecker.getFirstNotEmptyObj((Object[])new String[]{username, WeightScaleGeneralSettings.getLoginID()}));
        params.put("pass", (String)ObjectChecker.getFirstNotEmptyObj((Object[])new String[]{password, WeightScaleGeneralSettings.getLoginPassword()}));
        params.put("tem", (String)ObjectChecker.getFirstNotEmptyObj((Object[])new String[]{password, WeightScaleGeneralSettings.getLoginPassword()}));
        ArrayList<Pair> tempPrintIdsWithPrinterName = new ArrayList<Pair>();
        tempPrintIdsWithPrinterName.add(new Pair((Object)((String)lastLineTempPrintIdPair.getY()), (Object)WeightScaleUtils.fetchPrinterName()));
        ArrayList errors = new ArrayList();
        try {
            NamaPDFPrintUtil.instance().printReports(body, params, tempPrintIdsWithPrinterName, errors);
            if (ObjectChecker.isEmptyOrNull(errors)) {
                String lineCode = (String)lastLineTempPrintIdPair.getX();
                NaMaLogger.info((Object)("Line with lineCode: " + lineCode + " successfully printed"));
                ServiceProvider.getInstance().fillPrintedField(lineCode, result);
                return;
            }
            for (String error : errors) {
                result.failure(error, new Object[0]);
            }
        }
        catch (PrinterException | IOException | RuntimeException e) {
            result.failure("Printing sticker failed", new Object[0]);
            NaMaLogger.error((Throwable)e);
        }
    }

    public static void drawScreen(WeightScaleScreen screen) {
        if (cachedScreensMap == null) {
            WeightScaleUtils.initScreensMap();
        }
        stage.getScene().setRoot((Parent)cachedScreensMap.get((Object)screen));
    }

    private static void initScreensMap() {
        cachedScreensMap = new HashMap<WeightScaleScreen, Pane>();
        cachedScreensMap.put(WeightScaleScreen.LoginScreen, (Pane)new WeightScaleLoginScreen());
        cachedScreensMap.put(WeightScaleScreen.WeightScaleScreen, (Pane)new WeightScaleMainScreen(screenWidth));
    }

    public static void cacheStage(Stage primaryStage) {
        stage = primaryStage;
    }

    public static void showError(String message) {
        WeightScaleResult result = new WeightScaleResult();
        result.failure(WeightScaleTranslator.translate(message, new Object[0]), message);
        WeightScaleUtils.showError(result);
    }

    public static void showError(WeightScaleResult result) {
        WeightScaleErrorAndInfoMessagesUtil.showError(result, stage);
    }

    public static String calcAppVersion() {
        return WeightScaleUtils.pad(2025, 4) + "." + WeightScaleUtils.pad(12, 2) + "." + WeightScaleUtils.pad(15, 2) + "-" + WeightScaleUtils.pad(18, 2) + "." + WeightScaleUtils.pad(21, 2);
    }

    private static String pad(int i, int len) {
        return ServerStringUtils.leftPad((Integer)i, (Integer)len);
    }

    static {
        isStableWeightFlag = false;
        serialNumber = new SimpleStringProperty();
        DISCONNECTED = "disconnected";
        cachedScreensMap = null;
    }
}

