package com.namasoft.common;

import java.util.prefs.Preferences;

public class OSValidator
{
	private static String OS_Name = System.getProperty("os.name").toLowerCase();
	public static String OS_NameAbbr = isWindows() ? "w" : "l";
	public static int OS_Arch = System.getProperty("os.arch").toLowerCase().indexOf("64") != -1 ? 64 : 86;

	public static boolean isWindows()
	{
		return (OS_Name.indexOf("win") >= 0);
	}

	public static boolean isLinux()
	{
		return (OS_Name.indexOf("lin") >= 0 || OS_Name.indexOf("nux") >= 0 || OS_Name.indexOf("aix") > 0);
	}

	public static boolean is64()
	{
		return OS_Arch == 64;
	}

	public static boolean is86()
	{
		return OS_Arch == 86;
	}

	public static boolean isAdmin()
	{
		Preferences prefs = Preferences.systemRoot();
		try
		{
			prefs.put("foo", "bar"); // SecurityException on Windows
			prefs.remove("foo");
			prefs.flush(); // BackingStoreException on Linux
			return true;
		}
		catch (Exception e)
		{
			return false;
		}
	}

}
