package com.namasoft.common.cloudman.dtos;

import com.namasoft.common.utilities.ObjectChecker;

public class CloudServer
{
	private String id;
	private String name;
	private String rdpAddress;
	private String devRdpAddress;
	private String description;
	private String cloudProvider;
	private String cloudManURL;
	private String token;
	private Boolean updateInProgress;
	private String lastUpdateCheckResult;
	private String loggedInUsers;
	private String orderInList;
	private Long totalMemory;
	private Long usedMemory;
	private Long freeMemory;
	private String balanceApiURL;
	private String balanceApiToken;

	public String getId()
	{
		return id;
	}

	public void setId(String id)
	{
		this.id = id;
	}

	public String getCloudProvider()
	{
		return cloudProvider;
	}

	public void setCloudProvider(String cloudProvider)
	{
		this.cloudProvider = cloudProvider;
	}

	public String getDescription()
	{
		return description;
	}

	public void setDescription(String description)
	{
		this.description = description;
	}

	public String getName()
	{
		return name;
	}

	public void setName(String name)
	{
		this.name = name;
	}

	public String getRdpAddress()
	{
		return rdpAddress;
	}

	public void setRdpAddress(String rdpAddress)
	{
		this.rdpAddress = rdpAddress;
	}

	public String getCloudManURL()
	{
		return cloudManURL;
	}

	public void setCloudManURL(String cloudManURL)
	{
		this.cloudManURL = cloudManURL;
	}

	public String getToken()
	{
		return token;
	}

	public void setToken(String token)
	{
		this.token = token;
	}

	public Boolean getUpdateInProgress()
	{
		return updateInProgress;
	}

	public void setUpdateInProgress(Boolean updateInProgress)
	{
		this.updateInProgress = updateInProgress;
	}

	public String getLastUpdateCheckResult()
	{
		return lastUpdateCheckResult;
	}

	public void setLastUpdateCheckResult(String lastUpdateCheckResult)
	{
		this.lastUpdateCheckResult = lastUpdateCheckResult;
	}

	public String getLoggedInUsers()
	{
		return loggedInUsers;
	}

	public void setLoggedInUsers(String loggedInUsers)
	{
		this.loggedInUsers = loggedInUsers;
	}

	public String getDevRdpAddress()
	{
		return devRdpAddress;
	}

	public void setDevRdpAddress(String devRdpAddress)
	{
		this.devRdpAddress = devRdpAddress;
	}

	public String apiURL(String mainEndpoint, String operation)
	{
		String url = getCloudManURL();
		if (!url.endsWith("/"))
			url += "/";
		return url + "api/" + mainEndpoint + "/" + operation;
	}

	public String getOrderInList()
	{
		return orderInList;
	}

	public void setOrderInList(String orderInList)
	{
		this.orderInList = orderInList;
	}

	public String fetchOrderInList()
	{
		return ObjectChecker.getFirstNotEmptyObj(getOrderInList(), "0");
	}

	public Long getTotalMemory()
	{
		return totalMemory;
	}

	public void setTotalMemory(Long totalMemory)
	{
		this.totalMemory = totalMemory;
	}

	public Long getUsedMemory()
	{
		return usedMemory;
	}

	public void setUsedMemory(Long usedMemory)
	{
		this.usedMemory = usedMemory;
	}

	public Long getFreeMemory()
	{
		return freeMemory;
	}

	public void setFreeMemory(Long freeMemory)
	{
		this.freeMemory = freeMemory;
	}

	public String getBalanceApiURL()
	{
		return balanceApiURL;
	}

	public void setBalanceApiURL(String balanceApiURL)
	{
		this.balanceApiURL = balanceApiURL;
	}

	public String getBalanceApiToken()
	{
		return balanceApiToken;
	}

	public void setBalanceApiToken(String balanceApiToken)
	{
		this.balanceApiToken = balanceApiToken;
	}
}
