package com.namasoft.common.criteria;

import java.io.Serializable;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlTransient;

import com.namasoft.common.layout.TitledID;
import com.namasoft.common.layout.edit.NaMaText;

@SuppressWarnings("serial")
@XmlAccessorType(XmlAccessType.PROPERTY)
public class AllowedValue implements Serializable, TitledID
{
	private String value;
	private NaMaText title;

	@Override
	@XmlTransient
	public String getId()
	{
		return value;
	}

	public AllowedValue()
	{

	}

	public AllowedValue(String value, NaMaText title)
	{
		setValue(value);
		setTitle(title);
	}

	public String getValue()
	{
		return value;
	}

	public void setValue(String value)
	{
		this.value = value;
	}

	public NaMaText getTitle()
	{
		return title;
	}

	public void setTitle(NaMaText title)
	{
		this.title = title;
	}

	public static AllowedValue fromString(String str)
	{
		return new AllowedValue(str, NaMaText.resource(str));
	}

}
