package com.namasoft.common.criteria;

import com.namasoft.common.constants.Operator;
import com.namasoft.common.utilities.ObjectChecker;

import java.util.*;

@SuppressWarnings("serial")
public class DTOExpressionContainer
{
	public static List<DTOExperssion> criteriaToTree(DTOCriteria criteria)
	{
		List<DTOExperssion> roots = new ArrayList<DTOExperssion>();
		Stack<DTOExperssion> current = new Stack<DTOExperssion>();
		if (ObjectChecker.isNotEmptyOrNull(criteria.getExpressions()))
		{
			for (int i = 0; i < criteria.getExpressions().size(); i++)
			{
				DTOExperssion expression = criteria.getExpressions().get(i);
				if (ObjectChecker.areEqual(expression.getOperator(), Operator.OpenBracket))
				{
					if (current.empty())
						roots.add(expression);
					else
						current.peek().getChildren().add(expression);
					current.push(expression);//
				}
				else if (ObjectChecker.areEqual(expression.getOperator(), Operator.CloseBracket))
				{
					DTOExperssion openBracket = current.pop();
					openBracket.setRelation(expression.getRelation());
				}
				else
				{
					if (current.empty())
						roots.add(expression);
					else
						current.peek().getChildren().add(expression);
				}
			}
		}
		return roots;
	}

}
