package com.namasoft.common.flatobjects;

import com.namasoft.common.constants.DateWrapper;
import com.namasoft.common.fieldids.CommonFieldIds;
import com.namasoft.common.fieldids.Fields;
import com.namasoft.common.layout.metadata.BasicFieldMetaData;
import com.namasoft.common.layout.metadata.FieldType;
import com.namasoft.common.utilities.ObjectChecker;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;

public class CommonUtils
{

	public static boolean isReference(Object value, BasicFieldMetaData fieldMetaData)
	{
		if (value instanceof EntityReferenceData)
			return true;
		if (fieldMetaData != null
				&& (fieldMetaData.getFieldType() == FieldType.Reference || fieldMetaData.getFieldType() == FieldType.Genericreference))
			return true;
		if (value instanceof FlatObject)
		{
			FlatObject flatObj = (FlatObject) value;
			String actualClassName = flatObj.getActualClassName();
			if (ObjectChecker.areEqual(actualClassName, EntityReferenceData.class.getName())
					|| ObjectChecker.areEqual(actualClassName, EntityReferenceData.class.getName())
					|| ObjectChecker.areEqual(actualClassName, EntityReferenceData.class.getName()))
				return true;
		}
		return false;
	}

	public static boolean isMasterFile(Object value)
	{
		if (value instanceof EntityReferenceData)
			return true;
		if (value instanceof FlatObject)
		{
			FlatObject flatObj = (FlatObject) value;
			String actualClassName = flatObj.getActualClassName();
			if (ObjectChecker.areEqual(actualClassName, EntityReferenceData.class.getName()))
				return true;
		}
		return false;
	}

	public static boolean isDocumentFile(Object value)
	{
		if (value instanceof EntityReferenceData)
			return true;
		if (value instanceof FlatObject)
		{
			FlatObject flatObj = (FlatObject) value;
			String actualClassName = flatObj.getActualClassName();
			if (ObjectChecker.areEqual(actualClassName, EntityReferenceData.class.getName()))
				return true;
		}
		return false;
	}

	@SuppressWarnings("deprecation")
	public static String getObjectStringValue(Object value)
	{
		if (value == null)
			return "";
		if (CommonUtils.isReference(value, null))
			return getReferenceId(value);
		if (value instanceof Date)
		{
			Date date = (Date) value;
			if (date.getYear() < 0)
				return date.getHours() + ":" + date.getMinutes() + ":" + date.getSeconds() + ":00";
			else
			{
				//return (date.getDate() + "-" + (date.getMonth() + 1) + "-" + (date.getYear() + 1900));
				SimpleDateFormat df = new SimpleDateFormat("dd-MM-yyyy");
				return df.format(date);
			}

		}
		return value.toString();
	}

	private static String getReferenceId(Object value)
	{
		if (value instanceof EntityReferenceData)
			return ((EntityReferenceData) value).getId();
		else if (value instanceof FlatObject)
			return Fields.id((FlatObject) value);
		else
			throw new RuntimeException("Uknown reference type");
	}

	public static Object convertFromFlatObjectIfNeeded(Object fieldValue, BasicFieldMetaData fieldMetaData)
	{
		if (!isReference(fieldValue, fieldMetaData))
			return fieldValue;
		if (fieldValue instanceof FlatObject)
			return flatToEntityReference((FlatObject) fieldValue);
		if (fieldValue instanceof DateWrapper)
			fieldValue = ((DateWrapper) fieldValue).toDate();
		return fieldValue;
	}

	public static EntityReferenceData flatToEntityReference(FlatObject fieldValue)
	{
		if (fieldValue == null)
			return null;
		String id = Fields.id(fieldValue);
		String entityType = Fields.entityType(fieldValue);
		String code = Fields.code(fieldValue);
		String name1 = Fields.name1(fieldValue);
		String name2 = Fields.name2(fieldValue);
		String altCode = Fields.altCode(fieldValue);
		String actualCode = Fields.actualCode(fieldValue);
		Date valueDate = Fields.valueDate(fieldValue);
		FlatObject extraData = fieldValue.getFieldValue(CommonFieldIds.EXTRA_DATA);
		EntityReferenceData entityReferenceData = new EntityReferenceData(entityType, id, code, actualCode, altCode, name1, name2);;
		entityReferenceData.setValueDate(valueDate);
		if (ObjectChecker.isNotEmptyOrNull(extraData))
		{
			entityReferenceData.setExtraData(extraData.getValuesMap());
		}
		entityReferenceData.setColorCode(Fields.colorCode(fieldValue));
		return entityReferenceData;
	}

	public static Object convertToFlatObjectIfNeeded(Object fieldValue)
	{
		if (fieldValue == null)
			return fieldValue;
		if (fieldValue instanceof EntityReferenceData)
		{
			EntityReferenceData referenceData = (EntityReferenceData) fieldValue;
			FlatObject flatObject = new FlatObject();
			flatObject.setActualClassName(fieldValue.getClass().getName());
			flatObject.setFieldValue(CommonFieldIds.ID, referenceData.getId());
			flatObject.setFieldValue(CommonFieldIds.ENTITY_TYPE, referenceData.getEntityType());
			flatObject.setFieldValue(CommonFieldIds.CODE, referenceData.getCode());
			flatObject.setFieldValue(CommonFieldIds.DESCRIPTOR1, referenceData.getDescriptor1());
			flatObject.setFieldValue(CommonFieldIds.DESCRIPTOR2, referenceData.getDescriptor2());
			flatObject.setFieldValue(CommonFieldIds.COLOR_CODE, referenceData.getColorCode());
			EntityReferenceData mRefData = (EntityReferenceData) fieldValue;
			flatObject.setFieldValue(CommonFieldIds.NAME1, mRefData.getName1());
			flatObject.setFieldValue(CommonFieldIds.NAME2, mRefData.getName2());
			if (ObjectChecker.isNotEmptyOrNull(referenceData.extraData()))
			{
				FlatObject extraData = new FlatObject((HashMap<String, Object>) referenceData.extraData());
				extraData.setActualClassName(HashMap.class.getName());
				flatObject.setFieldValue(CommonFieldIds.EXTRA_DATA, extraData);
			}
			return flatObject;
		}
		if (fieldValue instanceof Date)
		{
			return new DateWrapper((Date) fieldValue);
		}
		return fieldValue;
	}
}
