package com.namasoft.common.flatobjects;

import jakarta.xml.bind.annotation.*;

import java.util.*;

@XmlAccessorType(XmlAccessType.PROPERTY)
@XmlRootElement
@SuppressWarnings({ "rawtypes" })
public class DTOGUITask implements IDTOTask
{
	private Date startTime;
	private EntityReferenceData user;
	private String message;
	private String progress;
	private String fromIP;
	private String taskId;
	private boolean markedForKill;
	private Date markedForKillOn;

	public DTOGUITask(Date startTime, EntityReferenceData user, String message, String fromIP)
	{
		this.startTime = startTime;
		this.user = user;
		this.message = message;
		this.fromIP = fromIP;
		this.taskId = UUID.randomUUID().toString();
	}

	public DTOGUITask()
	{
	}
	@Override
	public Date getStartTime()
	{
		return startTime;
	}

	public void setStartTime(Date startTime)
	{
		this.startTime = startTime;
	}
	@Override
	public EntityReferenceData getUser()
	{
		return user;
	}

	public void setUser(EntityReferenceData user)
	{
		this.user = user;
	}
	@Override
	public String getMessage()
	{
		return message;
	}
	public void setMessage(String message)
	{
		this.message = message;
	}

	@Override
	public String getFromIP()
	{
		return fromIP;
	}

	public void setFromIP(String fromIP)
	{
		this.fromIP = fromIP;
	}
	@Override
	public String getTaskId()
	{
		return taskId;
	}

	public void setTaskId(String taskId)
	{
		this.taskId = taskId;
	}

	@Override
	public boolean isMarkedForKill()
	{
		return markedForKill;
	}

	@Override
	public void setMarkedForKill(boolean markedForKill)
	{
		this.markedForKill = markedForKill;
	}
	@Override
	public Date getMarkedForKillOn()
	{
		return markedForKillOn;
	}

	@Override
	public void setMarkedForKillOn(Date markedForKillOn)
	{
		this.markedForKillOn = markedForKillOn;
	}

	public void setProgress(String progress)
	{
		this.progress = progress;
	}

	@Override
	public String getProgress()
	{
		return progress;
	}

	@Override
	public void updateProgress(String progress)
	{
		setProgress(progress);
	}
}
