package com.namasoft.common.flatobjects;

import com.namasoft.common.utilities.*;

import jakarta.xml.bind.annotation.*;
import java.io.Serializable;
import java.util.*;

@XmlAccessorType(XmlAccessType.PROPERTY)
@XmlRootElement
@SuppressWarnings({ "rawtypes", "serial" })
public class FlatObjectList implements Serializable, NamaObject, Cloneable
{

	ArrayList<Object> list = new ArrayList<Object>();
	private String actualClassName = "";

	public FlatObjectList(Collection<?> list)
	{
		this();
		if (list != null)
			this.list.addAll(list);
	}

	public FlatObjectList()
	{
	}

	public ArrayList<Object> getList()
	{
		return list;
	}

	public void setList(ArrayList<Object> list)
	{
		this.list = list;
	}

	public void setValue(Collection collection)
	{
		list.clear();
		for (Object object : collection)
		{
			list.add(object);
		}
	}

	public String getActualClassName()
	{
		return actualClassName;
	}

	public void setActualClassName(String actualClassName)
	{
		this.actualClassName = actualClassName;
	}

	@Override
	public boolean isEmpty()
	{
		if (ObjectChecker.isEmptyOrNull(getList()))
		{
			return true;
		}
		for (Object object : getList())
		{
			if (ObjectChecker.isNotEmptyOrNull(object))
				return false;
		}
		return true;
	}

	@Override
	public String toString()
	{
		return "type: " + getActualClassName() + " values: " + getList();
	}

	public Object clone()
	{
		FlatObjectList clone = new FlatObjectList();
		clone.setActualClassName(getActualClassName());
		ArrayList<Object> clonedList = new ArrayList<Object>();
		for (Object object : getList())
		{
			if (ObjectChecker.isNotEmptyOrNull(object))
			{
				clonedList.add(CommonFlatObjectUtils.clone(object));
			}
		}
		clone.setList(clonedList);
		return clone;
	}

	@Override
	public boolean equals(Object obj)
	{
		if (obj instanceof FlatObjectList)
		{
			// if (ObjectChecker.areNotEqual(getActualClassName(),
			// ((FlatObjectList) obj).getActualClassName()))
			// return false;
			ArrayList<Object> otherList = ((FlatObjectList) obj).getList();
			ArrayList<Object> thisList = getList();
			return ObjectChecker.areEqualIgnoringEmptyLines(thisList, otherList);
		}
		return super.equals(obj);
	}

	@Override
	public int hashCode()
	{
		return getActualClassName().hashCode() ^ getList().hashCode();
	}

	public void removeEmptyLines()
	{
		if (ObjectChecker.isEmptyOrNull(getList()))
			return;
		for (int i = getList().size() - 1; i >= 0; i--)
		{
			if (ObjectChecker.isEmptyOrNull(getList().get(i)))
				getList().remove(i);
		}

	}

	public FlatObjectList updateActualClassNameOfDetails(Class<?> klass)
	{
		return updateActualClassNameOfDetails(klass.getName());
	}

	public FlatObjectList updateActualClassNameOfDetails(String klass)
	{
		if (ObjectChecker.isEmptyOrNull(getList()))
			return this;
		for (Object o : getList())
		{
			if (o instanceof FlatObject)
				((FlatObject) o).setActualClassName(klass);
		}
		return this;
	}
}
