package com.namasoft.common.flatobjects;

import java.util.ArrayList;
import java.util.List;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;

import com.namasoft.common.NaMaDTO;

@SuppressWarnings("serial")
@XmlAccessorType(XmlAccessType.PROPERTY)
@XmlRootElement
public class FlatRecordList extends NaMaDTO
{
	private List<FlatRecord> records = new ArrayList<FlatRecord>();

	public List<FlatRecord> getRecords()
	{
		return records;
	}

	public void setRecords(List<FlatRecord> records)
	{
		this.records = records;
	}

	public void add(FlatObject record)
	{
		records.add(FlatRecord.fromFlatObject(record));
	}

}
