package com.namasoft.common.flatobjects;

import com.namasoft.common.constants.Language;
import com.namasoft.common.flatobjects.tempo.*;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utils.ServerCommonUtils;

public interface RendererPropertyResolver
{
	String resolve(String property, int rowNumber, boolean insideCreator, RenderNode calledFrom);

	String createPaymentUrl(Object document, Object config);

	Object resolveObject(String column, int row);

	int calcSizeForLoop(String loopDetailName);

	int listSize(String varName);

	INotificationInfo calcNotificationInfo(int currentLineNumber);

	String marshalInString(Object object);

	void loopStart(StringBuilder builder);

	void loopIterationStart(StringBuilder builder);

	void loopIterationEnd(StringBuilder builder);

	void loopEnd(StringBuilder builder);

	<T> Comparable<T> toDecimal(Object value);

	int compareValues(Object leftSideValue, Object rightSideValue, boolean numeric);

	boolean isTrueIfCondition(Object object);

	void tafqeet(Object value, Object currencyObj, StringBuilder builder, Language language);

	String calcSalesPriceForCustomer(ItemSalesPriceNode itemPriceNode, int currentLineNumber);

	String calcPurchasePriceForSupplier(ItemPurchasePriceNode itemPriceNode, int currentLineNumber);

	ExtractLinkInfo extractLinkInfo(Object first, Object entityType, Object id, Object title);

	void round(Object number, Object fractionalDecimalPlaces, StringBuilder builder);

	default String objectToUUIDIfPossible(Object id)
	{
		if (ObjectChecker.isEmptyOrNull(id))
			return null;
		if (id.getClass().isArray())
			return ServerCommonUtils.byteArrayToUUID((byte[]) id).toString();
		else
			return ObjectChecker.toStringOrEmpty(id);
	}

	void formatNumber(Object o, String format, StringBuilder builder);

	void formatDate(Object o, String format, StringBuilder builder);

	void enableDetailSqlFields(String collectionName);

	void clearFactoryFieldPrefixes();
}
