package com.namasoft.common.flatobjects.tempo;

import com.namasoft.common.constants.*;
import com.namasoft.common.flatobjects.LinkCreationParameters;
import com.namasoft.common.utilities.ObjectChecker;

public class AttachmentLinkNode extends AbsLinkNode
{

	public AttachmentLinkNode(String nodeContent)
	{
		super(nodeContent);
	}

	@Override
	public boolean isLeafNode()
	{
		return true;
	}

	@Override
	protected void renderLink(LinkCreationParameters p)
	{
		if (ObjectChecker.isEmptyOrNull(p.getId()))
			return;
		p.getBuilder().append(PlaceTokens.downloadURL(ObjectChecker.toStringOrEmpty(p.getId()), ObjectChecker.toStringOrEmpty(p.getEntityType()),
				DownloadPurpose.PREVIEW, false));
	}
}
