package com.namasoft.common.flatobjects.tempo;

import com.namasoft.common.flatobjects.RendererPropertyResolver;
import com.namasoft.common.utilities.*;
import com.namasoft.common.utils.ListViewUrlBuilder;

public class ListViewLinkPropertyNode extends RenderNode implements IListViewLinkSubNode
{
	private final String nodeContent;
	private final String propertyName;
	private final String expression;

	public ListViewLinkPropertyNode(String nodeContent, String propertyName)
	{
		this.nodeContent = nodeContent;
		this.propertyName = propertyName;
		this.expression = StringUtils.getInnerString(nodeContent, "(", ")");
	}

	@Override
	public boolean isLeafNode()
	{
		return true;
	}

	@Override
	public String describe()
	{
		return "{" + nodeContent + "}";
	}

	@Override
	public void render(StringBuilder builder, RendererPropertyResolver helper, int currentLineNumber)
	{
		throw new UnsupportedOperationException("The node " + describe() + " is misplaced.");
	}

	@Override
	public void apply(ListViewUrlBuilder builder, RendererPropertyResolver helper, int currentLineNumber)
	{
		String value = renderer.evalConstantOrVar(expression, helper, currentLineNumber, false, this);
		switch (propertyName)
		{
		case "listviewname":
			builder.listViewName(value);
			break;
		case "menucode":
			builder.menuCode(value);
			break;
		case "orderby":
			builder.orderBy(value);
			break;
		case "ascending":
			builder.ascending(ObjectChecker.isTrue(value));
			break;
		case "showtree":
			builder.showTree(ObjectChecker.isTrue(value));
			break;
		case "currentpage":
			builder.currentPage(ObjectChecker.tryParseInt(value));
			break;
		case "pagesize":
			builder.pageSize(ObjectChecker.tryParseInt(value));
			break;
		case "extracriteriaid":
			builder.extraCriteriaId(value);
			break;
		}
	}
}
