package com.namasoft.common.layout;

import com.namasoft.common.constants.Language;
import com.namasoft.common.layout.list.AbsListScreen;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utils.translation.TranslationUtil;

public class ListingSystemFields
{
	public Language lang;
	public int currentRecord = -1;
	public int currentPage;
	public int pageSize;
	public long totalRecords;
	private final AbsListScreen layout;

	public ListingSystemFields(AbsListScreen layout)
	{
		this.layout = layout;
	}

	public ListingSystemFields setLang(Language lang)
	{
		this.lang = lang;
		return this;
	}

	public ListingSystemFields setCurrentPage(int currentPage)
	{
		this.currentPage = currentPage;
		return this;
	}

	public ListingSystemFields setTotalRecords(long totalRecords)
	{
		this.totalRecords = totalRecords;
		return this;
	}

	public ListingSystemFields incrementRecord()
	{
		currentRecord++;
		return this;
	}

	public ListingSystemFields setPageSize(int pageSize)
	{
		this.pageSize = pageSize;
		return this;
	}

	public String translate(Object obj)
	{
		return TranslationUtil.translate(lang, ObjectChecker.toStringOrEmpty(obj));
	}

	public AbsListScreen getLayout()
	{
		return layout;
	}
}
