package com.namasoft.common.layout.edit;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@SuppressWarnings("serial")
public class CompositeEditScreenField extends EditScreenField implements Serializable
{
	private List<EditScreenField> subFields = new ArrayList<EditScreenField>();
	private Boolean labelAfterWidget;

	public List<EditScreenField> getSubFields()
	{
		return subFields;
	}

	public void setSubFields(List<EditScreenField> subFields)
	{
		this.subFields = subFields;
	}

	public Boolean getLabelAfterWidget()
	{
		return labelAfterWidget;
	}

	public void setLabelAfterWidget(Boolean labelAfterWidget)
	{
		this.labelAfterWidget = labelAfterWidget;
	}

	public CompositeEditScreenField widgetPercentages(int... widthes)
	{
		if (widthes.length != subFields.size())
			throw new RuntimeException("widthes.length != fields.size()");
		for (int i = 0; i < subFields.size(); i++)
		{
			subFields.get(i).widgetPercentage(widthes[i]);
		}
		return this;
	}

	public CompositeEditScreenField allWidgetsPercentage(int width)
	{
		for (int i = 0; i < subFields.size(); i++)
		{
			subFields.get(i).widgetPercentage(width);
		}
		return this;
	}

	public CompositeEditScreenField allTitlesPercentage(int width)
	{
		for (int i = 0; i < subFields.size(); i++)
		{
			subFields.get(i).titlePercentage(width);
		}
		return this;
	}

	public CompositeEditScreenField putLabelsAfterWidgets()
	{
		setLabelAfterWidget(true);
		return this;
	}

	public CompositeEditScreenField titlePercentages(int... widthes)
	{
		if (widthes.length != subFields.size())
			throw new RuntimeException("widthes.length != fields.size()");
		for (int i = 0; i < subFields.size(); i++)
		{
			subFields.get(i).titlePercentage(widthes[i]);
		}
		return this;
	}

	public CompositeEditScreenField hasNoTitles()
	{
		for (int i = 0; i < subFields.size(); i++)
		{
			subFields.get(i).hasNoTitle();
		}
		return this;
	}

	public CompositeEditScreenField hasTitles()
	{
		for (int i = 0; i < subFields.size(); i++)
		{
			subFields.get(i).hasTitle();
		}
		return this;
	}

	public CompositeEditScreenField hasTitles(boolean... hasTitles)
	{
		for (int i = 0; i < hasTitles.length; i++)
		{
			subFields.get(i).setHasTitle(hasTitles[i]);
		}
		return this;
	}

	public static CompositeEditScreenField create(String... ids)
	{
		return new CompositeEditScreenField().addIds(ids);
	}

	private CompositeEditScreenField addIds(String... ids)
	{
		for (String id : ids)
		{
			subFields.add(EditScreenField.of(id));
		}
		return this;
	}

	public CompositeEditScreenField showInQuickCreate()
	{
		setShowInQuickCreate(true);
		return this;
	}

	public CompositeEditScreenField doNoShowInQuickCreate()
	{
		setShowInQuickCreate(false);
		return this;
	}
}
