package com.namasoft.common.layout.edit;

import com.fasterxml.jackson.annotation.*;
import com.namasoft.common.layout.TitledID;
import com.namasoft.common.utilities.ObjectChecker;
import jakarta.xml.bind.annotation.XmlSeeAlso;

import java.io.Serializable;
import java.util.*;

@XmlSeeAlso({ CompositeEditScreenField.class, GUIActionPlaceholder.class })
@SuppressWarnings("serial")
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, property = "namaClassTypeId")
@JsonSubTypes({ @JsonSubTypes.Type(value = CompositeEditScreenField.class, name = "CompositeEditScreenField"),
		@JsonSubTypes.Type(value = GUIActionPlaceholder.class, name = "GUIActionPlaceholder"), })
public class EditScreenField implements Serializable, TitledID, ShowableInQuickCreate
{
	private String id;
	private EditScreenFieldLayout layout;
	private NaMaText title;
	private Integer titlePercentage = -1;
	private Integer widgetPercentage = -1;
	private Boolean hasTitle = false;
	private boolean showInQuickCreate = true;
	private String iconCode;

	@Override
	public NaMaText getTitle()
	{
		return title;
	}

	public void setTitle(NaMaText title)
	{
		this.title = title;
	}

	@Override
	public String getId()
	{
		return id;
	}

	public void setId(String id)
	{
		this.id = id;
	}

	public Integer getTitlePercentage()
	{
		return titlePercentage;
	}

	public void setTitlePercentage(Integer titlePercentage)
	{
		this.titlePercentage = titlePercentage;
	}

	public Integer getWidgetPercentage()
	{
		return widgetPercentage;
	}

	public void setWidgetPercentage(Integer widgetPercentage)
	{
		this.widgetPercentage = widgetPercentage;
	}

	public Boolean getHasTitle()
	{
		return hasTitle;
	}

	public void setHasTitle(Boolean hasTitle)
	{
		this.hasTitle = hasTitle;
	}

	public boolean isShowInQuickCreate()
	{
		return showInQuickCreate;
	}

	public void setShowInQuickCreate(boolean showInQuickCreate)
	{
		this.showInQuickCreate = showInQuickCreate;
	}

	public EditScreenField titlePercentage(Integer percentage)
	{
		setTitlePercentage(percentage);
		return this;
	}

	public EditScreenField widgetPercentage(Integer percentage)
	{
		setWidgetPercentage(percentage);
		return this;
	}

	public static EditScreenField of(String id)
	{
		EditScreenField editScreenField = new EditScreenField();
		editScreenField.setId(id);
		return editScreenField;
	}

	public EditScreenField hasNoTitle()
	{
		setHasTitle(false);
		return this;
	}

	public EditScreenField hasTitle()
	{
		setHasTitle(true);
		return this;
	}

	public EditScreenField()
	{
	}

	public EditScreenField(String id, NaMaText text)
	{
		this(id, text, null);
	}

	public EditScreenField(String id, NaMaText text, EditScreenFieldLayout layout)
	{
		this.layout = layout;
		this.title = text;
		this.id = id;
	}

	public EditScreenFieldLayout getLayout()
	{
		return layout;
	}

	public void setLayout(EditScreenFieldLayout layout)
	{
		this.layout = layout;
	}

	public EditScreenField id(String id)
	{
		setId(id);
		return this;
	}

	public EditScreenField title(NaMaText text)
	{
		setTitle(text);
		if (ObjectChecker.isEmptyOrNull(getId()) && ObjectChecker.isNotEmptyOrNull(text.getResourceId()))
			setId(text.getResourceId());
		return this;
	}

	public EditScreenField layout(EditScreenFieldLayout layout)
	{
		setLayout(layout);
		return this;
	}

	public EditScreenField alone()
	{
		return layout(EditScreenFieldLayout.alone);
	}

	public EditScreenField normal()
	{
		layout(EditScreenFieldLayout.normal);
		return this;
	}

	public EditScreenField spanned()
	{
		return layout(EditScreenFieldLayout.spanned);
	}

	public EditScreenField spanned2()
	{
		return layout(EditScreenFieldLayout.spanned2);
	}


	public static List<EditScreenField> of(String... ids)
	{
		List<EditScreenField> fields = new ArrayList<EditScreenField>();
		for (String id : ids)
		{
			fields.add(of(id));
		}
		return fields;
	}

	public EditScreenField showInQuickCreate()
	{
		setShowInQuickCreate(true);
		return this;
	}

	public EditScreenField doNoShowInQuickCreate()
	{
		setShowInQuickCreate(false);
		return this;
	}

	public String getIconCode()
	{
		return iconCode;
	}

	public void setIconCode(String iconCode)
	{
		this.iconCode = iconCode;
	}

	public void updateIconCodeIfNotEmpty(Object iconCode)
	{
		if (ObjectChecker.isEmptyOrNull(iconCode))
			return;
		setIconCode(ObjectChecker.toStringOrNull(iconCode));
	}

	public EditScreenField icon(String iconCode)
	{
		setIconCode(iconCode);
		return this;
	}
}
