package com.namasoft.common.layout.edit;

import com.namasoft.common.HasIDUtil;
import com.namasoft.common.constants.Language;
import com.namasoft.common.flatobjects.NaMaError;
import com.namasoft.common.layout.TitledID;
import com.namasoft.common.utilities.ObjectChecker;
import jakarta.xml.bind.annotation.*;

import java.util.*;
@XmlRootElement
@SuppressWarnings("serial")
@XmlAccessorType(XmlAccessType.PROPERTY)
public class EditScreenGrid extends EditScreenBlock implements TitledID, ShowableInQuickCreate
{
	private GridSize gridSize = GridSize.Medium;
	private List<EditScreenGridColumn> columns = new ArrayList<EditScreenGridColumn>();
	private List<GUIActionPlaceholder> actions = new ArrayList<>();
	private boolean showPager = true;

	public boolean getEditScreenGrid()
	{
		return true;
	}
	public GridSize getGridSize()
	{
		return gridSize;
	}

	public void setGridSize(GridSize gridSize)
	{
		this.gridSize = gridSize;
	}

	@XmlElementWrapper(name = "columns")
	@XmlElement(name = "column")
	public List<EditScreenGridColumn> getColumns()
	{
		return columns;
	}

	public void setColumns(List<EditScreenGridColumn> columns)
	{
		this.columns = columns;
	}

	public boolean isShowPager()
	{
		return showPager;
	}

	public void setShowPager(boolean showPager)
	{
		this.showPager = showPager;
	}

	public EditScreenGrid field(String fieldId)
	{
		setFieldId(fieldId);
		return this;
	}

	public EditScreenGridColumn addColumn()
	{
		EditScreenGridColumn screenGridColumn = new EditScreenGridColumn();
		getColumns().add(screenGridColumn);
		return screenGridColumn;
	}

	public EditScreenGridColumn addColumn(String id)
	{
		if (!id.startsWith(getId()))
			NaMaError.error("Grid id is " + getId() + " and you are adding column " + id + " from different grid ya montasser");
		return addColumn().field(id);
	}

	public EditScreenGrid size(GridSize gridSize)
	{
		setGridSize(gridSize);
		return this;
	}

	public EditScreenGrid addColumns(String... ids)
	{
		getColumns().addAll(EditScreenGridColumn.of(ids));
		return this;
	}

	public EditScreenGrid addHiddenColumns(String... ids)
	{
		List<EditScreenGridColumn> columns = EditScreenGridColumn.of(ids);
		columns.forEach(EditScreenGridColumn::hideInGrid);
		getColumns().addAll(columns);
		return this;
	}

	public EditScreenGrid addActions(String... ids)
	{
		Arrays.stream(ids).forEach(actionId -> getActions().add(GUIActionPlaceholder.of(actionId)));
		return this;
	}

	public void setActions(List<GUIActionPlaceholder> actions)
	{
		this.actions = actions;
	}

	public List<GUIActionPlaceholder> getActions()
	{
		return actions;
	}

	public EditScreenGrid addColumnsWithWidthes(String... idsAndWidthes)
	{
		if (idsAndWidthes.length % 2 != 0)
			throw new RuntimeException("idsAndWidthes must be even number");
		for (int i = 0; i < idsAndWidthes.length; i += 2)
		{
			addColumn(idsAndWidthes[i]).width(idsAndWidthes[i + 1]);
		}
		return this;
	}

	public EditScreenGrid title(NaMaText text)
	{
		setTitle(text);
		return this;
	}

	public EditScreenGrid title()
	{
		title(NaMaText.resource(getFieldId()));
		return this;
	}

	public EditScreenGrid showPager()
	{
		setShowPager(true);
		return this;
	}

	public EditScreenGrid doNotShowPager()
	{
		setShowPager(false);
		return this;
	}

	@Override
	@XmlTransient
	public String getId()
	{
		return getFieldId();
	}

	public List<EditScreenGridColumn> listVisibleColumns(Language currentLang)
	{
		List<EditScreenGridColumn> allVisibleColumns = new ArrayList<EditScreenGridColumn>();
		for (EditScreenGridColumn column : getColumns())
		{
			boolean show = column.isShowInFullView() || column.isShowInGridView();
			boolean matchLang = ObjectChecker.isEmptyOrNull(column.getShowOnlyInLang()) || column.getShowOnlyInLang() == currentLang;
			if (show && matchLang)
				allVisibleColumns.add(column);
		}
		return allVisibleColumns;
	}

	public boolean containsColumn(String columnId)
	{
		return HasIDUtil.find(columnId, getColumns()) != null;
	}

	public EditScreenGrid showInQuickCreate()
	{
		setShowInQuickCreate(true);
		return this;
	}

	public EditScreenGrid doNoShowInQuickCreate()
	{
		setShowInQuickCreate(false);
		return this;
	}

	public EditScreenGrid addColumnsAfter(String after, String... ids)
	{
		for (String id : ids)
		{
			addColumnAfter(after, id);
			after = id;
		}
		return this;
	}

	public EditScreenGrid addColumnsWithWidthsAfter(String after, String... idsAndWidths)
	{
		for (int i = 0; i < idsAndWidths.length; i += 2)
		{
			addColumnAfter(after, idsAndWidths[i]).width(idsAndWidths[i + 1]);
			after = idsAndWidths[i];
		}
		return this;
	}

	public EditScreenGridColumn addColumnAfter(String after, String id)
	{
		EditScreenGridColumn c = addColumn(id);
		getColumns().remove(c);
		for (int i = 0; i < getColumns().size(); i++)
		{
			if (getColumns().get(i).getId().equals(after))
			{
				getColumns().add(i + 1, c);
				return c;
			}
		}
		getColumns().add(c);
		return c;
	}

	public List<EditScreenGridColumn> listVisibleColumnsInGird(Language currentLang)
	{
		List<EditScreenGridColumn> allVisibleColumns = new ArrayList<>();
		for (EditScreenGridColumn column : getColumns())
		{
			boolean show = column.isShowInGridView();
			boolean matchLang = ObjectChecker.isEmptyOrNull(column.getShowOnlyInLang()) || column.getShowOnlyInLang() == currentLang;
			if (show && matchLang)
				allVisibleColumns.add(column);
		}
		return allVisibleColumns;
	}

	@Override
	public List<String> subFieldsIds()
	{
		return HasIDUtil.getIds(getColumns());
	}

	public void unifiedColumnWidth(String width)
	{
		for (EditScreenGridColumn column : getColumns())
		{
			column.setWidth(width);
		}
	}
}
