package com.namasoft.common.layout.edit;

import com.namasoft.common.layout.ScreenLayout;
import com.namasoft.common.utilities.ObjectChecker;
import jakarta.xml.bind.annotation.*;

import java.util.*;

@SuppressWarnings("serial")
@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class EditScreenLayout extends ScreenLayout
{
	private Boolean createdFromScreenEditor;
	private EditScreenLayout mobileScreen;
	private EditScreenLayout quickCreatorScreen;
	private EditScreenStyle screenStyle;
	private List<EditScreenPage> pages = new ArrayList<EditScreenPage>();
	private List<GUIActionPlaceholder> moreActions;
	private Boolean removeDiscussionField;
	private Boolean removeDiscussionAtt1;
	private Boolean removeDiscussionAtt2;
	private Boolean removeDiscussionAtt3;
	private Boolean removeDiscussionAtt4;
	private Boolean removeDiscussionRef1;
	private Boolean removeDiscussionRef2;
	private List<GUIActionPlaceholder> editScreenToolbarActions;

	public Boolean getRemoveDiscussionField()
	{
		return removeDiscussionField;
	}

	public void setRemoveDiscussionField(Boolean removeDiscussionField)
	{
		this.removeDiscussionField = removeDiscussionField;
	}

	public Boolean getRemoveDiscussionAtt1()
	{
		return removeDiscussionAtt1;
	}

	public void setRemoveDiscussionAtt1(Boolean removeDiscussionAtt1)
	{
		this.removeDiscussionAtt1 = removeDiscussionAtt1;
	}

	public Boolean getRemoveDiscussionAtt2()
	{
		return removeDiscussionAtt2;
	}

	public void setRemoveDiscussionAtt2(Boolean removeDiscussionAtt2)
	{
		this.removeDiscussionAtt2 = removeDiscussionAtt2;
	}

	public Boolean getRemoveDiscussionAtt3()
	{
		return removeDiscussionAtt3;
	}

	public void setRemoveDiscussionAtt3(Boolean removeDiscussionAtt3)
	{
		this.removeDiscussionAtt3 = removeDiscussionAtt3;
	}

	public Boolean getRemoveDiscussionAtt4()
	{
		return removeDiscussionAtt4;
	}

	public void setRemoveDiscussionAtt4(Boolean removeDiscussionAtt4)
	{
		this.removeDiscussionAtt4 = removeDiscussionAtt4;
	}

	public Boolean getRemoveDiscussionRef1()
	{
		return removeDiscussionRef1;
	}

	public void setRemoveDiscussionRef1(Boolean removeDiscussionRef1)
	{
		this.removeDiscussionRef1 = removeDiscussionRef1;
	}

	public Boolean getRemoveDiscussionRef2()
	{
		return removeDiscussionRef2;
	}

	public void setRemoveDiscussionRef2(Boolean removeDiscussionRef2)
	{
		this.removeDiscussionRef2 = removeDiscussionRef2;
	}

	public EditScreenStyle getScreenStyle()
	{
		return screenStyle;
	}

	public void setScreenStyle(EditScreenStyle screenStyle)
	{
		this.screenStyle = screenStyle;
	}

	@XmlElementWrapper(name = "pages")
	@XmlElement(name = "page")
	public List<EditScreenPage> getPages()
	{
		return pages;
	}

	public void setPages(List<EditScreenPage> pages)
	{
		this.pages = pages;
	}

	@XmlElementWrapper(name = "moreActions")
	@XmlElement(name = "moreAction")
	public List<GUIActionPlaceholder> getMoreActions()
	{
		return moreActions;
	}

	public void setMoreActions(List<GUIActionPlaceholder> moreActions)
	{
		this.moreActions = moreActions;
	}

	public EditScreenPage addPage()
	{
		EditScreenPage screenPage = new EditScreenPage();
		getPages().add(screenPage);
		return screenPage;
	}

	public EditScreenLayout addMoreActions(String... actions)
	{
		for (String action : actions)
		{
			addMoreAction().id(action);
		}
		return this;
	}

	public GUIActionPlaceholder addMoreAction()
	{
		GUIActionPlaceholder actionPlaceholder = new GUIActionPlaceholder();
		if (getMoreActions() == null)
			setMoreActions(new ArrayList<>());
		getMoreActions().add(actionPlaceholder);
		return actionPlaceholder;
	}

	public List<EditScreenField> listAllNormalFields()
	{
		ArrayList<EditScreenField> fields = new ArrayList<EditScreenField>();
		for (EditScreenPage page : getPages())
			fields.addAll(page.listAllNormalFields());
		return fields;
	}

	public List<EditScreenGridColumn> listAllColumnFields()
	{
		ArrayList<EditScreenGridColumn> fields = new ArrayList<EditScreenGridColumn>();
		for (EditScreenPage page : getPages())
			fields.addAll(page.listAllColumnFields());
		return fields;
	}

	public EditScreenLayout selectable()
	{
		setSelectable(true);
		return this;
	}

	public EditScreenLayout notSelectable()
	{
		setSelectable(false);
		return this;
	}

	public EditScreenLayout getMobileScreen()
	{
		return mobileScreen;
	}

	public void setMobileScreen(EditScreenLayout mobileScreen)
	{
		this.mobileScreen = mobileScreen;
	}

	public EditScreenLayout getQuickCreatorScreen()
	{
		return quickCreatorScreen;
	}

	public void setQuickCreatorScreen(EditScreenLayout quickCreatorScreen)
	{
		this.quickCreatorScreen = quickCreatorScreen;
	}

	@Override
	public EditScreenLayout fetchMobileScreen()
	{
		return getMobileScreen();
	}

	public Boolean getCreatedFromScreenEditor()
	{
		return createdFromScreenEditor;
	}

	public void setCreatedFromScreenEditor(Boolean createdFromScreenEditor)
	{
		this.createdFromScreenEditor = createdFromScreenEditor;
	}

	@Override
	public boolean shouldNotApplySystemModifiers()
	{
		return ObjectChecker.isTrue(getCreatedFromScreenEditor());
	}

	public List<GUIActionPlaceholder> getEditScreenToolbarActions()
	{
		return editScreenToolbarActions;
	}

	public void setEditScreenToolbarActions(List<GUIActionPlaceholder> editScreenToolbarActions)
	{
		this.editScreenToolbarActions = editScreenToolbarActions;
	}

	public void addToolbarActions(String... actions)
	{
		if (getEditScreenToolbarActions() == null)
			setEditScreenToolbarActions(new ArrayList<>());
		for (String action : actions)
		{
			getEditScreenToolbarActions().add(GUIActionPlaceholder.of(action));
		}
	}
}
