package com.namasoft.common.layout.edit;

import com.namasoft.common.criteria.DTOFilledQuestionField;
import com.namasoft.common.layout.TitledID;
import com.namasoft.common.utilities.*;
import jakarta.xml.bind.annotation.*;

import java.util.*;

@XmlRootElement
@SuppressWarnings("serial")
@XmlAccessorType(XmlAccessType.PROPERTY)
public class EditScreenList extends EditScreenBlock implements TitledID
{
	private EditScreenListLinkType linkType;
	private String linkFieldId;
	private String listViewEntityType;
	private String listViewId;
	private boolean hideLinkField = true;
	private boolean collapsible = true;
	private boolean openByDefault = false;
	private String id;
	private NaMaText title;
	private String sourceField;
	private GridSize size;
	private List<DTOFilledQuestionField> overriddenQuestions;
	private List<String> hiddenQuestions;

	public boolean getEditScreenList()
	{
		return true;
	}

	public EditScreenList questionFieldIds(String... questionFieldIds)
	{
		return questionFieldId(String.join(",", questionFieldIds));
	}
	/**
	 * @param questionFieldId
	 *            comma separated questions, if needed
	 * @return
	 */
	public EditScreenList questionFieldId(String questionFieldId)
	{
		linkType(EditScreenListLinkType.QuestionField);
		setLinkFieldId(questionFieldId);
		return this;
	}

	public EditScreenList criteriaFieldId(String criteriaFieldId)
	{
		linkType(EditScreenListLinkType.CriteriField);
		setLinkFieldId(criteriaFieldId);
		return this;
	}

	public EditScreenList listViewEntityType(String listViewEntityType)
	{
		setListViewEntityType(listViewEntityType);
		return this;
	}

	public EditScreenList listViewId(String listViewId)
	{
		if (ObjectChecker.isEmptyOrNull(getFieldId()))
			setFieldId(listViewId);
		if (ObjectChecker.isEmptyOrNull(getId()))
			setId(listViewId);
		setListViewId(listViewId);
		return this;
	}

	public EditScreenList linkType(EditScreenListLinkType linkType)
	{
		setLinkType(linkType);
		return this;
	}

	public EditScreenList collapsible()
	{
		setCollapsible(true);
		return this;
	}

	public EditScreenList notCollapsible()
	{
		setCollapsible(false);
		return this;
	}

	public EditScreenList openByDefault()
	{
		setOpenByDefault(true);
		return this;
	}

	public EditScreenList notOpenByDefault()
	{
		setOpenByDefault(false);
		return this;
	}

	public EditScreenListLinkType getLinkType()
	{
		return linkType;
	}

	public void setLinkType(EditScreenListLinkType linkType)
	{
		this.linkType = linkType;
	}

	public String getLinkFieldId()
	{
		return linkFieldId;
	}

	public void setLinkFieldId(String linkFieldId)
	{
		this.linkFieldId = linkFieldId;
	}

	public String getListViewEntityType()
	{
		return listViewEntityType;
	}

	public void setListViewEntityType(String listViewEntityType)
	{
		this.listViewEntityType = listViewEntityType;
	}

	public String getListViewId()
	{
		return listViewId;
	}

	public void setListViewId(String listViewId)
	{
		this.listViewId = listViewId;
	}

	public boolean isHideLinkField()
	{
		return hideLinkField;
	}

	public void setHideLinkField(boolean hideLinkField)
	{
		this.hideLinkField = hideLinkField;
	}

	public boolean isCollapsible()
	{
		return collapsible;
	}

	public void setCollapsible(boolean collapsible)
	{
		this.collapsible = collapsible;
	}

	public boolean isOpenByDefault()
	{
		return openByDefault;
	}

	public void setOpenByDefault(boolean openByDefault)
	{
		this.openByDefault = openByDefault;
	}

	public String getId()
	{
		return id;
	}

	public void setId(String id)
	{
		setFieldId(id);
		this.id = id;
	}

	public NaMaText getTitle()
	{
		return title;
	}

	public void setTitle(NaMaText title)
	{
		this.title = title;
	}

	public String getSourceField()
	{
		return sourceField;
	}

	public void setSourceField(String sourceField)
	{
		this.sourceField = sourceField;
	}

	public GridSize getSize()
	{
		return size;
	}

	public void setSize(GridSize size)
	{
		this.size = size;
	}

	public List<DTOFilledQuestionField> getOverriddenQuestions()
	{
		return overriddenQuestions;
	}

	public void setOverriddenQuestions(List<DTOFilledQuestionField> overriddenQuestions)
	{
		this.overriddenQuestions = overriddenQuestions;
	}

	public EditScreenList title(NaMaText title)
	{
		setTitle(title);
		if (ObjectChecker.isEmptyOrNull(getFieldId()))
			setFieldId(title.getResourceId());
		if (ObjectChecker.isEmptyOrNull(getId()))
			setId(title.getResourceId());
		return this;
	}

	public EditScreenList id(String id)
	{
		setId(id);
		return this;
	}

	public EditScreenList size(GridSize size)
	{
		setSize(size);
		return this;
	}

	public EditScreenList showInQuickCreate()
	{
		setShowInQuickCreate(true);
		return this;
	}

	public EditScreenList doNoShowInQuickCreate()
	{
		setShowInQuickCreate(false);
		return this;
	}

	/**
	 * @param sourceField
	 *            comma separated source fields, if needed
	 * @return
	 */
	public EditScreenList sourceField(String sourceField)
	{
		setSourceField(sourceField);
		return this;
	}

	public EditScreenList addOverriddenQuestions(List<DTOFilledQuestionField> questions)
	{
		if (getOverriddenQuestions() == null)
			setOverriddenQuestions(new ArrayList<>());
		getOverriddenQuestions().addAll(questions);
		return this;
	}

	public List<String> getHiddenQuestions()
	{
		return hiddenQuestions;
	}

	public void setHiddenQuestions(List<String> hiddenQuestions)
	{
		this.hiddenQuestions = hiddenQuestions;
	}

	public EditScreenList hiddenQuestions(String... hiddenQuestions)
	{
		setHiddenQuestions(CollectionsUtility.asList(hiddenQuestions));
		return this;
	}
}
