package com.namasoft.common.layout.edit;

import java.io.Serializable;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlTransient;

import com.namasoft.common.utilities.NamaObject;
import com.namasoft.common.utilities.ObjectChecker;

@SuppressWarnings("serial")
@XmlAccessorType(XmlAccessType.PROPERTY)
public class NaMaText implements Serializable, NamaObject
{
	private String resourceId;
	private String arabicText;
	private String englishText;

	private NaMaText(String arabic, String english)
	{
		setArabicText(arabic);
		setEnglishText(english);
	}

	private NaMaText(String resourceId)
	{
		setResourceId(resourceId);
	}

	private NaMaText()
	{
	}

	public String getResourceId()
	{
		return resourceId;
	}

	public void setResourceId(String resourceId)
	{
		this.resourceId = resourceId;
	}

	public String getArabicText()
	{
		return arabicText;
	}

	public void setArabicText(String arabicText)
	{
		this.arabicText = arabicText;
	}

	public String getEnglishText()
	{
		return englishText;
	}

	public void setEnglishText(String englishText)
	{
		this.englishText = englishText;
	}

	public boolean resourceId()
	{
		return ObjectChecker.isNotEmptyOrNull(getResourceId());
	}

	@XmlTransient
	public boolean isEmpty()
	{
		return ObjectChecker.areAllEmptyOrNull(getResourceId(), getArabicText(), getEnglishText());
	}

	public static NaMaText resource(String resourceId)
	{
		return new NaMaText(resourceId);
	}

	public static NaMaText text(String arabic, String english)
	{
		return new NaMaText(arabic, english);
	}

	public static NaMaText none()
	{
		return resource("{0}");
	}

	public static NaMaText resOrText(String resource, String arabic, String english)
	{
		NaMaText t = new NaMaText();
		t.setArabicText(arabic);
		t.setEnglishText(english);
		t.setResourceId(resource);
		return t;
	}

	@Override
	public boolean equals(Object obj)
	{
		if (!(obj instanceof NaMaText) || obj == null)
			return super.equals(obj);
		NaMaText other = (NaMaText) obj;
		return ObjectChecker.areEqual(other.getArabicText(), getArabicText()) && ObjectChecker.areEqual(other.getEnglishText(), getEnglishText())
				&& ObjectChecker.areEqual(other.getResourceId(), getResourceId());
	}

	public static NaMaText pleaseSelectRows()
	{
		return resource("pleaseSelectRows");
	}
}
