package com.namasoft.common.layout.metadata;

import com.namasoft.common.HasId;
import com.namasoft.common.criteria.AllowedValue;
import com.namasoft.common.fieldids.NotGeneratedFields;
import com.namasoft.common.utilities.ObjectChecker;

import jakarta.xml.bind.annotation.XmlTransient;
import java.io.Serializable;
import java.util.List;

@SuppressWarnings("serial")
public class BasicFieldMetaData implements Serializable, HasId
{
	private String fieldId;
	private FieldType fieldType;
	private FieldSubType fieldSubType;
	private String referencedEntityType;
	private String defaultEntityType;
	private List<String> allowedValues;
	private List<AllowedValue> allowedValuesTitles;
	private String enumTypeName;
	private Boolean hijri;
	private Boolean list;
	private Boolean doNotAutoShowList;
	private Boolean richText;

	public BasicFieldMetaData()
	{

	}

	public BasicFieldMetaData(String id)
	{
		setFieldId(id);
	}

	public String getFieldId()
	{
		return fieldId;
	}

	public void setFieldId(String fieldId)
	{
		this.fieldId = fieldId;
	}

	public FieldType getFieldType()
	{
		return fieldType;
	}

	public void setFieldType(FieldType fieldType)
	{
		this.fieldType = fieldType;
	}

	public FieldSubType getFieldSubType()
	{
		return fieldSubType;
	}

	public void setFieldSubType(FieldSubType fieldSubType)
	{
		this.fieldSubType = fieldSubType;
	}

	public String getReferencedEntityType()
	{
		return referencedEntityType;
	}

	public void setReferencedEntityType(String referencedEntityType)
	{
		this.referencedEntityType = referencedEntityType;
	}

	public List<String> getAllowedValues()
	{
		return allowedValues;
	}

	public void setAllowedValues(List<String> allowedValues)
	{
		this.allowedValues = allowedValues;
	}

	public String getEnumTypeName()
	{
		return enumTypeName;
	}

	public void setEnumTypeName(String enumTypeName)
	{
		this.enumTypeName = enumTypeName;
	}

	@Override
	public boolean equals(Object obj)
	{
		if (!(obj instanceof BasicFieldMetaData))
			return false;

		return ObjectChecker.areEqual(getFieldId(), ((BasicFieldMetaData) obj).getFieldId());
	}

	@Override
	public int hashCode()
	{
		return getFieldId().hashCode();
	}

	public void cloneTo(BasicFieldMetaData basicFieldMetaData)
	{
		basicFieldMetaData.fieldId = this.fieldId;
		basicFieldMetaData.fieldType = this.fieldType;
		basicFieldMetaData.referencedEntityType = this.referencedEntityType;
		basicFieldMetaData.allowedValues = this.allowedValues;
		basicFieldMetaData.enumTypeName = this.enumTypeName;
		basicFieldMetaData.hijri  = this.hijri;
		basicFieldMetaData.defaultEntityType = this.defaultEntityType;
		basicFieldMetaData.allowedValuesTitles = this.allowedValuesTitles;
		basicFieldMetaData.list = this.list;
		basicFieldMetaData.doNotAutoShowList = this.doNotAutoShowList;
		basicFieldMetaData.richText = this.richText;
	}

	@Override
	public String toString()
	{
		return getFieldId();
	}

	@Override
	@XmlTransient
	public String getId()
	{
		return getFieldId();
	}

	public void setHijri(Boolean hijri)
	{
		this.hijri = hijri;
	}

	public Boolean getHijri()
	{
		return hijri;
	}

	public void setList(Boolean list)
	{
		this.list = list;
	}

	public Boolean getList()
	{
		return list;
	}

	public String getDefaultEntityType()
	{
		return defaultEntityType;
	}

	public void setDefaultEntityType(String defaultEntityType)
	{
		this.defaultEntityType = defaultEntityType;
	}

	public void setDoNotAutoShowList(Boolean doNotAutoShowList)
	{
		this.doNotAutoShowList = doNotAutoShowList;
	}

	public Boolean getDoNotAutoShowList()
	{
		return doNotAutoShowList;
	}

	public List<AllowedValue> getAllowedValuesTitles()
	{
		return allowedValuesTitles;
	}

	public void setAllowedValuesTitles(List<AllowedValue> allowedValuesTitles)
	{
		this.allowedValuesTitles = allowedValuesTitles;
	}

	public Boolean getRichText()
	{
		return richText;
	}

	public void setRichText(Boolean richText)
	{
		this.richText = richText;
	}

	public BasicFieldMetaData enumTypeName(String enumTypeName)
	{
		setEnumTypeName(enumTypeName);
		return this;
	}

	public boolean baseEntityUserField()
	{
		if (ObjectChecker.areEqual(fieldId, NotGeneratedFields.firstAuthor))
			return true;
		if (ObjectChecker.areEqual(fieldId, NotGeneratedFields.revisedBy))
			return true;
		return false;
	}
}
